/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fcs.formplugin.risk.FieldSeqComparator;

public class ErrorFieldMapEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private final Set<String> visitField = new HashSet<String>(Arrays.asList("company", "billno", "bizdate", "biztime", "account", "counterparty", "oppunit", "debitamount", "creditamount", "description", "paybank", "oppbank"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcfieldname"});
        BasedataEdit sceneCulling = (BasedataEdit)this.getControl("sceneculling");
        sceneCulling.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit featureCulling = (BasedataEdit)this.getControl("featureculling");
        featureCulling.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setFieldMapPolicy();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFieldVisible();
    }

    private void setFieldMapPolicy() {
        MainEntityType destEntityType = this.getMainType("destentity");
        ArrayList<IDataEntityProperty> allFields = new ArrayList<IDataEntityProperty>();
        int allFieldCount = 0;
        for (EntityType entityType : destEntityType.getAllEntities().values()) {
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (!this.visitField.contains(property.getName()) || !(property instanceof IFieldHandle) || !((IFieldHandle)property).isConvertTote() || !EntityParseHelper.isSupportConvField((MainEntityType)destEntityType, (IDataEntityProperty)property)) continue;
                allFields.add(property);
                ++allFieldCount;
            }
        }
        allFields.sort(new FieldSeqComparator(destEntityType));
        int rowCount = this.getModel().getEntryRowCount("entry");
        if (rowCount < allFieldCount) {
            this.getModel().batchCreateNewEntryRow("entry", allFieldCount - rowCount);
        }
        if (rowCount > allFieldCount) {
            for (int rowIndex = rowCount - 1; rowIndex >= allFieldCount; --rowIndex) {
                this.getModel().deleteEntryRow("entry", rowIndex);
            }
        }
        int rowIndex = 0;
        for (IDataEntityProperty property : allFields) {
            DynamicProperty field = (DynamicProperty)property;
            String targetFieldKey = field.getName();
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)property);
            this.getModel().setValue("destfield", (Object)targetFieldKey, rowIndex);
            this.getModel().setValue("destfieldname", (Object)targetFieldName, rowIndex);
            ++rowIndex;
        }
    }

    private MainEntityType getMainType(String prop) {
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue(prop);
        return EntityMetadataCache.getDataEntityType((String)destEntity.getString("number"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("srcfieldname".equals(key)) {
            this.doClearFieldValue(e.getChangeSet());
        } else if ("beforeculling".equals(key)) {
            this.setFieldVisible();
        } else if ("srcentity".equals(key)) {
            this.getModel().setValue("featureculling", null);
            this.getModel().setValue("sceneculling", null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("srcfieldname".equals(control.getKey()) && TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"srcentity")) {
            this.doClickSourceField();
        }
    }

    private void setFieldVisible() {
        boolean isBeforeCulling = (Boolean)this.getModel().getValue("beforeculling");
        this.getView().setVisible(Boolean.valueOf(isBeforeCulling), new String[]{"featureculling", "sceneculling"});
    }

    private void doClickSourceField() {
        MainEntityType targetMainType = this.getMainType("destentity");
        int row = this.getModel().getEntryCurrentRowIndex("entry");
        String targetFieldValue = (String)this.getModel().getValue("destfield", row);
        IDataEntityProperty targetProperty = targetMainType.findProperty(targetFieldValue);
        if (targetProperty == null) {
            return;
        }
        MainEntityType sourceMainType = this.getMainType("srcentity");
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeChildEntity(false);
        option.setIncludeBDPropPK(false);
        option.setOnlyPhysicsField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(srcBillNode);
    }

    private void showSelectFieldForm(TreeNode srcBillNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "srcfieldname"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if ("srcfieldname".equals(actionId)) {
            MainEntityType mainType = this.getMainType("srcentity");
            this.receiveSelectField(mainType, (String)args.getReturnData());
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex("entry");
        this.getModel().setValue("srcfield", (Object)returnPropName, row);
        this.getModel().setValue("srcfieldname", (Object)fieldCaption, row);
    }

    private void doClearFieldValue(ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            if (!StringUtils.isBlank((Object)changeData.getNewValue())) continue;
            this.getModel().setValue("srcfield", null, changeData.getRowIndex());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if ("sceneculling".equals(property) || "featureculling".equals(property)) {
            boolean mustInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"srcentity");
            if (mustInput) {
                DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                qFilters.add(new QFilter("billentity", "=", srcEntity.getPkValue()));
            } else {
                evt.setCancel(true);
            }
        }
    }
}

