/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Comparator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.OrgProp;

class FieldSeqComparator
implements Comparator<IDataEntityProperty> {
    private MainEntityType mainType;

    public FieldSeqComparator(MainEntityType mainType) {
        this.mainType = mainType;
    }

    @Override
    public int compare(IDataEntityProperty o1, IDataEntityProperty o2) {
        IDataEntityType p2;
        IDataEntityType p1 = o1.getParent();
        int result = this.compareSameParent(p1, o1, p2 = o2.getParent(), o2);
        if (result != 0) {
            return result;
        }
        result = this.comparHead(p1, o1, p2, o2);
        if (result != 0) {
            return result;
        }
        result = this.compareEntry(p1, o1, p2, o2);
        if (result != 0) {
            return result;
        }
        result = this.compareSubEntry(p1, o1, p2, o2);
        if (result != 0) {
            return result;
        }
        return o1.getOrdinal() - o2.getOrdinal();
    }

    private int compareSameParent(IDataEntityType p1, IDataEntityProperty o1, IDataEntityType p2, IDataEntityProperty o2) {
        int result;
        if (!StringUtils.equalsIgnoreCase((CharSequence)p1.getName(), (CharSequence)p2.getName())) {
            return 0;
        }
        if (p1 instanceof MainEntityType && p2 instanceof MainEntityType) {
            if (o1 instanceof OrgProp && !(o2 instanceof OrgProp)) {
                return -1;
            }
            if (!(o1 instanceof OrgProp) && o2 instanceof OrgProp) {
                return 1;
            }
            if (o1 instanceof BillTypeProp && !(o2 instanceof BillTypeProp)) {
                return -1;
            }
            if (!(o1 instanceof BillTypeProp) && o2 instanceof BillTypeProp) {
                return 1;
            }
        }
        if ((result = o1.getOrdinal() - o2.getOrdinal()) != 0) {
            return result;
        }
        return -1;
    }

    private int comparHead(IDataEntityType p1, IDataEntityProperty o1, IDataEntityType p2, IDataEntityProperty o2) {
        if (p1 instanceof MainEntityType && !(p2 instanceof MainEntityType)) {
            return -1;
        }
        if (!(p1 instanceof MainEntityType) && p2 instanceof MainEntityType) {
            return 1;
        }
        return 0;
    }

    private int compareEntry(IDataEntityType p1, IDataEntityProperty o1, IDataEntityType p2, IDataEntityProperty o2) {
        IDataEntityType e1 = p1;
        IDataEntityType e2 = p2;
        while (!(e1.getParent() instanceof MainEntityType)) {
            e1 = e1.getParent();
        }
        while (!(e2.getParent() instanceof MainEntityType)) {
            e2 = e2.getParent();
        }
        IDataEntityProperty ep1 = this.mainType.findProperty(e1.getName());
        IDataEntityProperty ep2 = this.mainType.findProperty(e2.getName());
        return ep1.getOrdinal() - ep2.getOrdinal();
    }

    private int compareSubEntry(IDataEntityType p1, IDataEntityProperty o1, IDataEntityType p2, IDataEntityProperty o2) {
        if (p1 instanceof SubEntryType && !(p2 instanceof SubEntryType)) {
            return 1;
        }
        if (!(p1 instanceof SubEntryType) && p2 instanceof SubEntryType) {
            return -1;
        }
        IDataEntityProperty ep1 = this.mainType.findProperty(p1.getName());
        IDataEntityProperty ep2 = this.mainType.findProperty(p2.getName());
        return ep1.getOrdinal() - ep2.getOrdinal();
    }
}

