/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.ErrorFieldMapHelper;

public class RealScreeningPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"datarange"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date currentDate = DateUtils.getCurrentDate();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"startdate", (Object)DateUtils.getMinMonthDate((Date)currentDate));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"enddate", (Object)DateUtils.getMaxMonthDate((Date)currentDate));
        QFilter qFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        Map riskScreenData = TmcDataServiceHelper.loadFromCache((String)"fcs_riskscreening", (String)"id,billentity", (QFilter[])qFilter.toArray());
        ComboEdit dataTypeComboEdit = (ComboEdit)this.getControl("datatype");
        ArrayList<ComboItem> dataTypeComboItemList = new ArrayList<ComboItem>(10);
        HashMap<String, String> cache = new HashMap<String, String>(16);
        for (DynamicObject value : riskScreenData.values()) {
            DynamicObject billEntity = value.getDynamicObject("billentity");
            LocaleString displayName = new LocaleString(billEntity.getString("name"));
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(displayName);
            String riskId = String.valueOf(value.get("id"));
            comboItem.setValue(riskId);
            dataTypeComboItemList.add(comboItem);
            cache.put(riskId, billEntity.getString("number") + "#" + billEntity.getString("name"));
        }
        this.getPageCache().put(cache);
        dataTypeComboEdit.setComboItems(dataTypeComboItemList);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if ("org".equals(fieldName) || "startdate".equals(fieldName) || "enddate".equals(fieldName) || "datatype".equals(fieldName)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"datarange", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if ("org".equals(property)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fcs_risktrade_platform", (String)"47150e89000000ac");
            QFilter orgFilter = new QFilter("id", "in", (Object)authOrgIds);
            qFilters.add(orgFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("datarange".equals(control.getKey()) && TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"datatype")) {
            this.showBillForm();
        }
    }

    private void showBillForm() {
        String dataType = (String)this.getModel().getValue("datatype");
        String entity = this.getPageCache().get(dataType).split("#")[0];
        DynamicObject errorFieldMap = ErrorFieldMapHelper.getErrorFieldMapBySrcEntity((String)entity);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)true);
        if (EmptyUtil.isNoEmpty((DynamicObject)errorFieldMap)) {
            String bizDateField;
            DynamicObjectCollection org;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            DynamicObjectCollection entrys = errorFieldMap.getDynamicObjectCollection("entry");
            String companyField = ErrorFieldMapHelper.querySrcFieldPropByDestField((DynamicObjectCollection)entrys, (String)"company");
            if (companyField != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(org = (DynamicObjectCollection)this.getModel().getValue("org")))) {
                List orgIds = org.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter(companyField, "in", orgIds));
            }
            if ((bizDateField = ErrorFieldMapHelper.querySrcFieldPropByDestField((DynamicObjectCollection)entrys, (String)"bizdate")) != null) {
                Date startDate = (Date)this.getModel().getValue("startdate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                QFilter dateQfilter = new QFilter(bizDateField, ">=", (Object)startDate);
                dateQfilter.and(bizDateField, "<=", (Object)endDate);
                qFilters.add(dateQfilter);
            }
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "datarange"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.contains("datarange") && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            String firesBillNo = rows.get(0).getBillNo();
            if (firesBillNo == null) {
                String idNos = rows.stream().map(s -> String.valueOf(s.getPrimaryKeyValue())).collect(Collectors.joining(";"));
                this.getModel().setValue("datarange", (Object)idNos);
            } else {
                String billNos = rows.stream().map(ListSelectedRow::getBillNo).collect(Collectors.joining(";"));
                this.getModel().setValue("datarange", (Object)billNos);
            }
            List pkIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            this.getModel().setValue("billid_tag", (Object)SerializationUtils.toJsonString(pkIds));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey)) {
            OperateOption option = op.getOption();
            String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
            option.setVariableValue("pageId", pageId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("confirm".equals(opKey) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String orgInfo;
            String dataType = (String)this.getModel().getValue("datatype");
            String entity = this.getPageCache().get(dataType).split("#")[1];
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            String billIdStr = (String)this.getModel().getValue("billid_tag");
            HashMap<String, String> returnMap = new HashMap<String, String>(16);
            returnMap.put("datatype", entity);
            returnMap.put("startdate", DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd"));
            returnMap.put("enddate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
            returnMap.put("billIdStr", billIdStr);
            returnMap.put("datatypeid", dataType);
            long startTime = System.currentTimeMillis();
            returnMap.put("startTime", String.valueOf(startTime));
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)org)) {
                orgInfo = ((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getString("name");
                if (org.size() > 1) {
                    orgInfo = ResManager.loadKDString((String)"%s\u7b49", (String)"RealScreeningPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[]{orgInfo});
                }
            } else {
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                DynamicObject rootOrg = TmcOrgDataHelper.getOrgById((long)rootOrgId);
                orgInfo = ResManager.loadKDString((String)"%s\u7b49", (String)"RealScreeningPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[]{rootOrg.get("name")});
            }
            returnMap.put("orgInfo", ResManager.loadKDString((String)"%s\u7ec4\u7ec7", (String)"RealScreeningPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[]{orgInfo}));
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }
}

