/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RiskBillLogList
extends AbstractListPlugin {
    public static final String VIEWDETAIL = "viewdetail";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dataCollection = super.getData(start, limit);
                dataCollection.forEach(t -> t.set("execinfo", (Object)String.format(ResManager.loadKDString((String)"\u7b5b\u67e5\u9879%1$d\u6761\uff0c\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761", (String)"RiskBillLogList_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), t.getInt("execnum"), t.getInt("successnum"), t.getInt("failnum"))));
                return dataCollection;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (VIEWDETAIL.equals(op.getOperateKey())) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("billlistap");
            Long id = (Long)billList.getFocusRowPkId();
            DynamicObject billLog = QueryServiceHelper.queryOne((String)"fcs_riskbill_log", (String)"batchid,billno", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            String batchIds = billLog.getString("batchid");
            if (EmptyUtil.isBlank((CharSequence)batchIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b5b\u67e5\u9879\u6267\u884c\u3002", (String)"RiskBillLogList_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                return;
            }
            List batchIdList = Arrays.stream(org.apache.commons.lang3.StringUtils.split((String)batchIds, (String)",")).filter(StringUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fcs_riskscreen_log");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            List qFilters = parameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", batchIdList));
            parameter.setCustomParam("billno", (Object)billLog.getString("billno"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

