/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Collection;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RiskCheckScopeEnum;
import kd.tmc.fcs.common.enums.ScreenItemEnum;
import org.apache.commons.collections.CollectionUtils;

public class RiskDiagItemEdit
extends AbstractBasePlugIn {
    private static final int MAX_FILTER_DESC = 500;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flconditionname", "flobjscopname", "paramfield"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (EmptyUtil.isEmpty((Object)parameter.getPkId())) {
            Object appBill = parameter.getCustomParam("appbill");
            Object screenItem = parameter.getCustomParam("screenitem");
            IDataModel model = this.getModel();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"appbill", (Object)appBill);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"screenitem", (Object)screenItem);
            this.addParamEntryByScreenItem(screenItem);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String screenItem = model.getDataEntity().getString("screenitem");
        if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)screenItem, (CharSequence[])new CharSequence[]{ScreenItemEnum.GROUP_BUSINESS.getValue(), ScreenItemEnum.TRADE_ONESELF.getValue()})) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"similarity"});
        }
    }

    private void addParamEntryByScreenItem(Object screenItem) {
        if (ScreenItemEnum.TRADE_INTERCHANGE.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.OTHER.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "forwardpayaccount", ResManager.loadKDString((String)"\u6b63\u5411-\u4ed8\u6b3e\u8d26\u53f7", (String)"RiskDiagItemEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"RiskDiagItemEdit_3", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "forwardrecaccount", ResManager.loadKDString((String)"\u6b63\u5411-\u6536\u6b3e\u8d26\u53f7", (String)"RiskDiagItemEdit_4", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "reversepayaccount", ResManager.loadKDString((String)"\u9006\u5411-\u4ed8\u6b3e\u8d26\u53f7", (String)"RiskDiagItemEdit_5", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "recamount", ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"RiskDiagItemEdit_6", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "reverserecaccount", ResManager.loadKDString((String)"\u9006\u5411-\u6536\u6b3e\u8d26\u53f7", (String)"RiskDiagItemEdit_7", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.TRADE_ONESELF.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.CONTENT.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "opbanknum", ResManager.loadKDString((String)"\u5bf9\u65b9\u94f6\u884c\u8d26\u53f7\uff0c\u7528\u4e8e\u5224\u65ad\u5185\u90e8\u5f80\u6765", (String)"RiskDiagItemEdit_22", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "desc", ResManager.loadKDString((String)"\u4e8b\u7531", (String)"RiskDiagItemEdit_30", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "company", ResManager.loadKDString((String)"\u672c\u5355\u636e\u5bf9\u65b9\u516c\u53f8", (String)"RiskDiagItemEdit_25", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "companyname", ResManager.loadKDString((String)"\u5de5\u5546\u4fe1\u606f\u516c\u53f8", (String)"RiskDiagItemEdit_14", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "business", ResManager.loadKDString((String)"\u5de5\u5546\u4fe1\u606f\u7ecf\u8425\u8303\u56f4", (String)"RiskDiagItemEdit_15", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.GROUP_BUSINESS.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.OTHER.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "company", ResManager.loadKDString((String)"\u672c\u5355\u636e\u5bf9\u65b9\u516c\u53f8", (String)"RiskDiagItemEdit_25", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "checkcompany", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u5355\u636e\u5bf9\u65b9\u516c\u53f8", (String)"RiskDiagItemEdit_26", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "companyname", ResManager.loadKDString((String)"\u5de5\u5546\u4fe1\u606f\u516c\u53f8", (String)"RiskDiagItemEdit_14", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "business", ResManager.loadKDString((String)"\u5de5\u5546\u4fe1\u606f\u7ecf\u8425\u8303\u56f4", (String)"RiskDiagItemEdit_15", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "accountbank", ResManager.loadKDString((String)"\u672c\u5355\u636e\u516c\u53f8", (String)"RiskDiagItemEdit_12", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "checkaccount", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u5355\u636e\u516c\u53f8", (String)"RiskDiagItemEdit_13", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "opbanknum", ResManager.loadKDString((String)"\u672c\u5355\u636e\u5bf9\u65b9\u8d26\u53f7", (String)"RiskDiagItemEdit_28", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "checkopbanknum", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u5355\u636e\u5bf9\u65b9\u8d26\u53f7", (String)"RiskDiagItemEdit_29", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.TRADE_AMOUNT.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.OTHER.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "srcAmount", ResManager.loadKDString((String)"\u672c\u5355\u91d1\u989d", (String)"RiskDiagItemEdit_8", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "srcOrg", ResManager.loadKDString((String)"\u672c\u5355\u7ec4\u7ec7", (String)"RiskDiagItemEdit_9", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "srcAcctBank", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u6237", (String)"RiskDiagItemEdit_10", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "colAmount", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u91d1\u989d", (String)"RiskDiagItemEdit_16", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "filterOrg", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u7ec4\u7ec7", (String)"RiskDiagItemEdit_17", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "filterAcctBank", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u8d26\u6237", (String)"RiskDiagItemEdit_18", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "rejectAcctBank", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u53f7\u5254\u9664", (String)"RiskDiagItemEdit_23", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.TRADE_FREQUENCY.getValue().equals(screenItem) || ScreenItemEnum.TRADE_TIME.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.OTHER.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "srcDate", ResManager.loadKDString((String)"\u672c\u5355\u4ea4\u6613\u65e5\u671f", (String)"RiskDiagItemEdit_19", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "srcOrg", ResManager.loadKDString((String)"\u672c\u5355\u7ec4\u7ec7", (String)"RiskDiagItemEdit_9", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "srcAcctBank", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u6237", (String)"RiskDiagItemEdit_10", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "colDate", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u4ea4\u6613\u65e5\u671f", (String)"RiskDiagItemEdit_20", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "filterOrg", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u7ec4\u7ec7", (String)"RiskDiagItemEdit_17", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "filterAcctBank", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u8d26\u6237", (String)"RiskDiagItemEdit_18", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "rejectAcctBank", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u53f7\u5254\u9664", (String)"RiskDiagItemEdit_23", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.RECPAY_RELATION.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.CONTENT.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "orgCheckLeft", ResManager.loadKDString((String)"\u672c\u5355\u7ec4\u7ec7", (String)"RiskDiagItemEdit_9", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "orgCheckRight", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u4ea4\u6613\u5bf9\u624b", (String)"RiskDiagItemEdit_21", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "acctBankSelfReject", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u53f7\u5254\u9664", (String)"RiskDiagItemEdit_23", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "relationShipField", ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"RiskDiagItemEdit_27", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        } else if (ScreenItemEnum.UNIT_RELATION.getValue().equals(screenItem) || ScreenItemEnum.BUSINESS_RELATION.getValue().equals(screenItem)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"checkway", (Object)RiskCheckScopeEnum.OTHER.getValue());
            int row = this.getModel().getEntryCurrentRowIndex("filterentry");
            DynamicObject paramObj = (DynamicObject)this.getModel().getEntryEntity("filterentry").get(row);
            if (EmptyUtil.isNoEmpty((DynamicObject)paramObj)) {
                DynamicObjectCollection paramEntry = paramObj.getDynamicObjectCollection("paramentry");
                this.addParamEntry(paramEntry, "orgCheckLeft", ResManager.loadKDString((String)"\u672c\u5355\u7ec4\u7ec7", (String)"RiskDiagItemEdit_9", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "orgCheckRight", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u4ea4\u6613\u5bf9\u624b", (String)"RiskDiagItemEdit_21", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "srcOrg", ResManager.loadKDString((String)"\u672c\u5355\u7ec4\u7ec7", (String)"RiskDiagItemEdit_9", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "filterOrg", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u7ec4\u7ec7", (String)"RiskDiagItemEdit_17", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "acctBankSelfReject", ResManager.loadKDString((String)"\u672c\u5355\u8d26\u53f7\u5254\u9664", (String)"RiskDiagItemEdit_23", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "acctBankObjReject", ResManager.loadKDString((String)"\u7b5b\u67e5\u5bf9\u8c61\u8d26\u53f7\u5254\u9664", (String)"RiskDiagItemEdit_24", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                this.addParamEntry(paramEntry, "relationShipField", ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"RiskDiagItemEdit_27", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void addParamEntry(DynamicObjectCollection paramEntry, String param, String paramInfo) {
        DynamicObject addNew = paramEntry.addNew();
        addNew.set("param", (Object)param);
        addNew.set("paraminfo", (Object)paramInfo);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "flconditionname": {
                    this.showAppBillForm();
                    break;
                }
                case "flobjscopname": {
                    this.showObjectScopeForm();
                    break;
                }
                case "paramfield": {
                    this.showRowSelectFieldForm(key);
                }
            }
        }
    }

    private void showAppBillForm() {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("filterentry");
        DynamicObject dataEntity = model.getDataEntity();
        String value = (String)model.getValue("flcondition_tag", row);
        this.openFilter("flconditionname", dataEntity.getDynamicObject("appbill").getString("number"), value);
    }

    private void showObjectScopeForm() {
        if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"flobject")) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex("filterentry");
            String value = (String)model.getValue("flobjscope_tag", row);
            DynamicObject objBill = (DynamicObject)model.getValue("flobject", row);
            this.openFilter("flobjscopname", objBill.getString("number"), value);
        }
    }

    private void openFilter(String key, String billEntity, String conditionJson) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billEntity);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fieldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", mainType.getName());
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showRowSelectFieldForm(String key) {
        IDataModel model = this.getModel();
        int row = this.getModel().getEntryCurrentRowIndex("filterentry");
        int subRow = this.getModel().getEntryCurrentRowIndex("paramentry");
        if (EmptyUtil.isEmpty((Object)model.getValue("parambill", subRow, row))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u5355\u636e\u3002", (String)"RiskDiagItemEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject paramObj = (DynamicObject)((DynamicObject)model.getEntryEntity("filterentry").get(row)).getDynamicObjectCollection("paramentry").get(subRow);
        String entityType = paramObj.getDynamicObject("parambill").getString("number");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)entityType);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityType);
        option.setIncludeChildEntity(true);
        option.setIncludeBDPropPK(false);
        option.setOnlyPhysicsField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u53ef\u9009\u62e9\u5b57\u6bb5\u3002", (String)"RiskDiagItemEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        String toJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", toJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("checkway".equals(name)) {
            model.deleteEntryData("filterentry");
            Object newValue = changeData.getNewValue();
            model.batchCreateNewEntryRow("filterentry", 1);
            if (RiskCheckScopeEnum.CONTENT.getValue().equals(newValue)) {
                model.setValue("flobject", model.getValue("appbill"), 0);
            }
        } else if ("parambill".equals(name)) {
            int row = model.getEntryCurrentRowIndex("filterentry");
            int subRow = model.getEntryCurrentRowIndex("paramentry");
            model.setValue("paramfield", null, subRow, row);
            this.getView().updateView("parambill", subRow, row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (Objects.nonNull(returnData)) {
            String actionId = e.getActionId();
            IDataModel model = this.getModel();
            if ("paramfield".equals(actionId)) {
                int row = model.getEntryCurrentRowIndex("filterentry");
                int subRow = this.getModel().getEntryCurrentRowIndex("paramentry");
                if (EmptyUtil.isNotBlank((CharSequence)returnData.toString())) {
                    String[] split = org.apache.commons.lang3.StringUtils.split((String)returnData.toString(), (String)",");
                    model.setValue("paramfield", (Object)split[0], subRow, row);
                }
            } else if ("flconditionname".equals(actionId)) {
                this.setFilterEntryExpression("flconditionname", "flcondition_tag", e);
            } else if ("flobjscopname".equals(actionId)) {
                this.setFilterEntryExpression("flobjscopname", "flobjscope_tag", e);
            }
        }
    }

    private void setFilterEntryExpression(String descKey, String tagKey, ClosedCallBackEvent evt) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("filterentry");
        String condition = Optional.ofNullable(evt.getReturnData()).map(Objects::toString).orElse(null);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            model.setValue(tagKey, (Object)condition, row);
            String desp = "";
            if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                desp = filterObj.getExprTran();
            }
            if (desp.length() > 500) {
                desp = desp.substring(0, 500);
            }
            model.setValue(descKey, (Object)desp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        boolean bl = isSuccess = null != args.getOperationResult() && args.getOperationResult().isSuccess();
        if (isSuccess && "save".equals(args.getOperateKey())) {
            IDataModel model = this.getModel();
            Object dataId = model.getDataEntity().get("id");
            this.getView().returnDataToParent(dataId);
            this.getView().close();
        }
    }
}

