/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RiskFeatureCullingEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"destfieldname"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("feature_tag".equals(key)) {
            String featureTag = (String)this.getModel().getValue("feature_tag");
            if (EmptyUtil.isNoEmpty((String)featureTag) && featureTag.length() > 255) {
                featureTag = featureTag.substring(0, 250);
            }
            this.getModel().setValue("feature", (Object)featureTag);
            this.getModel().setValue("featureshow", (Object)featureTag);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("destfieldname".equals(control.getKey())) {
            this.doClickDestField();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("featureset".equals(operateKey)) {
            LargeTextEdit control = (LargeTextEdit)this.getView().getControl("feature");
            control.click();
        }
    }

    private void doClickDestField() {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"fcs_errordata");
        PropTreeBuildOption option = new PropTreeBuildOption(null, TextProp.class);
        option.setCurrentEntity("fcs_errordata");
        option.setIncludeChildEntity(false);
        option.setIncludeBDRefProp(false);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)targetMainType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(srcBillNode);
    }

    private void showSelectFieldForm(TreeNode srcBillNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "destfieldname"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if ("destfieldname".equals(actionId)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"fcs_errordata");
            this.receiveSelectField(mainType, (String)args.getReturnData());
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex("entry");
        this.getModel().setValue("destfield", (Object)returnPropName, row);
        this.getModel().setValue("destfieldname", (Object)fieldCaption, row);
    }
}

