/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Collections;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.tmc.fcs.common.helper.LicenseCheckHelper;

public class RiskLicenseCheckFormPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(RiskLicenseCheckFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult licenseCheckResult = LicenseCheckHelper.checkUserInProGPTFas();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            logger.info("RiskLicenseCheckFormPlugin fail" + licenseCheckResult.getMsg());
            e.setCancel(true);
            e.setCancelMessage(licenseCheckResult.getMsg());
            e.setCancelFormShowParameter(LicenseServiceHelper.buildNoticeFormShowParameter((String)licenseCheckResult.getMsg(), Collections.singletonList(licenseCheckResult.getMsg())).toString());
        }
        logger.info("RiskLicenseCheckFormPlugin pass");
    }
}

