/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RiskRealProgressTaskPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(RiskRealProgressTaskPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnclose"});
        Label label = (Label)this.getControl("labelap");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String showWay = (String)customParams.get("showWay");
        Object dataType = customParams.get("datatype");
        if ("auto".equals(showWay)) {
            Object orgInfo = customParams.get("orgInfo");
            Object startDate = customParams.get("startdate");
            Object endDate = customParams.get("enddate");
            label.setText(String.format(ResManager.loadKDString((String)"%1$s\u62bd\u53d6%2$s\u5728\u201c%3$s~%4$s\u201d\u65e5\u671f\u8303\u56f4\u7684%5$s\u6570\u636e", (String)"RiskRealProgressTaskPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), "\uff1a", orgInfo, startDate, endDate, dataType));
            Label time = (Label)this.getControl("time");
            time.setText("00:00");
            this.getPageCache().put("recordStartTime", "true");
        } else if ("click".equals(showWay)) {
            String taskId = (String)customParams.get("taskId");
            if (EmptyUtil.isEmpty((String)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            String taskInfoData = taskInfo.getData();
            if (EmptyUtil.isNoEmpty((String)taskInfoData)) {
                Map resultData = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
                String status = (String)resultData.get("status");
                if ("1".equals(status)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnasync"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnclose"});
                    String startTime = (String)customParams.get("startTime");
                    this.calTimeCost(startTime, taskInfo.getEndTime() + 1000L);
                    this.getPageCache().put("excuteFinish", "true");
                    this.getModel().setValue("stepstatus", (Object)3);
                    this.setViewByStep(4);
                    label.setText(ResManager.loadKDString((String)"%s\u6570\u636e\u5206\u6790\u5b8c\u6210", (String)"RiskRealProgressTaskPlugin_3", (String)"tmc-fcs-formplugin", (Object[])new Object[]{"\uff1a" + dataType}));
                    Image image = (Image)this.getControl("imageap");
                    image.setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk.png");
                }
            } else {
                this.setViewByStep(2);
                label.setText(ResManager.loadKDString((String)"\u667a\u80fd\u7b97\u6cd5\u8ba1\u7b97\u5206\u6790\uff08\u8d22\u52a1\u5927\u6a21\u578b\uff09%s\u6570\u636e", (String)"RiskRealProgressTaskPlugin_2", (String)"tmc-fcs-formplugin", (Object[])new Object[]{"\uff1a" + dataType}));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getControl("progress");
        bar.start();
    }

    private void setViewByStep(int steps) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        Map<String, Integer> currentStepMap = Collections.singletonMap("currentStep", steps);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    public void onProgress(ProgressEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taskId = (String)customParams.get("taskId");
        if (EmptyUtil.isEmpty((String)taskId)) {
            return;
        }
        String startTime = (String)customParams.get("startTime");
        if (this.getPageCache().get("excuteFinish") == null) {
            this.calTimeCost(startTime, System.currentTimeMillis());
        }
        Label label = (Label)this.getControl("labelap");
        Object dataType = customParams.get("datatype");
        int costSecounds = this.calSecoundsBetween(startTime, System.currentTimeMillis());
        if (costSecounds == 2) {
            this.setViewByStep(1);
            label.setText(ResManager.loadKDString((String)"%s\u6570\u636e\u7279\u5f81\u63d0\u53d6\uff0c\u8fdb\u884c\u591a\u7279\u5f81\u53ec\u56de", (String)"RiskRealProgressTaskPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[]{"\uff1a" + dataType}));
        } else if (costSecounds == 5) {
            this.setViewByStep(2);
            label.setText(ResManager.loadKDString((String)"\u667a\u80fd\u7b97\u6cd5\u8ba1\u7b97\u5206\u6790\uff08\u8d22\u52a1\u5927\u6a21\u578b\uff09%s\u6570\u636e", (String)"RiskRealProgressTaskPlugin_2", (String)"tmc-fcs-formplugin", (Object[])new Object[]{"\uff1a" + dataType}));
        }
        if (costSecounds > 5) {
            Map resultData;
            String status;
            TaskInfo taskInfo;
            String taskInfoData;
            int step = (Integer)this.getModel().getValue("stepstatus");
            if (step == 3) {
                try {
                    Thread.sleep(1000L);
                    this.setViewByStep(4);
                    label.setText(ResManager.loadKDString((String)"%s\u6570\u636e\u5206\u6790\u5b8c\u6210", (String)"RiskRealProgressTaskPlugin_3", (String)"tmc-fcs-formplugin", (Object[])new Object[]{"\uff1a" + dataType}));
                    Image image = (Image)this.getControl("imageap");
                    image.setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk.png");
                    e.setProgress(100);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnasync"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnclose"});
                }
                catch (InterruptedException ex) {
                    logger.error("RiskRealProgressTaskPlugin error" + ex);
                }
            }
            if (EmptyUtil.isNoEmpty((String)(taskInfoData = (taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).getData())) && step != 3 && "1".equals(status = (String)(resultData = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class)).get("status"))) {
                this.setViewByStep(3);
                this.getModel().setValue("stepstatus", (Object)3);
            }
        }
    }

    private void calTimeCost(String startTime, long endTime) {
        Label time = (Label)this.getControl("time");
        long millis = endTime - Long.parseLong(startTime);
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        String formattedDuration = String.format("%02d:%02d", minutes, remainingSeconds);
        time.setText(formattedDuration);
    }

    private int calSecoundsBetween(String startTime, long endTime) {
        long millis = endTime - Long.parseLong(startTime);
        long seconds = millis / 1000L;
        return Integer.parseInt(String.valueOf(seconds));
    }
}

