/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcFormHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RiskScreenEdit
extends AbstractBasePlugIn
implements CellClickListener,
RowClickEventListener {
    private static final String CARDENTRYROWAP = "cardentryrowap";
    private static final String TODEL_ITEM = "todel_item";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid gridControl = (EntryGrid)this.getControl("subentry");
        gridControl.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{CARDENTRYROWAP, "conditiondesc"});
        CardEntry typeNameEntry = (CardEntry)this.getControl("entry");
        typeNameEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTempTypeName();
    }

    private void setTempTypeName() {
        IDataModel model = this.getModel();
        int rowEntry = model.getEntryCurrentRowIndex("entry");
        Object typeName = model.getValue("typename", rowEntry);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"temptypename", (Object)typeName);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"tempsuccessres", (Object)model.getValue("successres", rowEntry));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("entry");
        switch (name) {
            case "temptypename": {
                if (row < 0) break;
                model.setValue("typename", changeData.getNewValue(), row);
                break;
            }
            case "tempsuccessres": {
                if (row < 0) break;
                model.setValue("successres", changeData.getNewValue(), row);
                break;
            }
            case "billentity": {
                model.deleteEntryData("entry");
                model.batchCreateNewEntryRow("entry", 1);
                break;
            }
            case "screenitem": {
                int rowEntry = model.getEntryCurrentRowIndex("entry");
                int rowSubEntry = model.getEntryCurrentRowIndex("subentry");
                Object screenId = model.getValue("screensetting", rowSubEntry, rowEntry);
                if (!EmptyUtil.isNoEmpty((Object)screenId)) break;
                model.setValue("screensetting", (Object)0L, rowSubEntry, rowEntry);
                IPageCache pageCache = this.getPageCache();
                String toDelItems = pageCache.get(TODEL_ITEM);
                toDelItems = EmptyUtil.isNotBlank((CharSequence)toDelItems) ? toDelItems + "," + screenId : screenId.toString();
                pageCache.put(TODEL_ITEM, toDelItems);
                break;
            }
            case "conditiondesc": {
                if (!EmptyUtil.isEmpty((Object)changeData.getNewValue())) break;
                model.setValue("condition", null);
                model.setValue("condition_tag", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key = ((Control)evt.getSource()).getKey();
            if (CARDENTRYROWAP.equals(key)) {
                this.setTempTypeName();
            } else if ("conditiondesc".equals(key)) {
                this.showStartConditionForm();
            }
        }
    }

    private void showStartConditionForm() {
        if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"billentity")) {
            IDataModel model = this.getModel();
            String value = (String)model.getValue("condition_tag");
            DynamicObject objBill = (DynamicObject)model.getValue("billentity");
            this.openFilter(objBill.getString("number"), value);
        }
    }

    private void openFilter(String billEntity, String conditionJson) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billEntity);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fieldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", mainType.getName());
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditiondesc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("screensettingdesc".equals(actionId) && EmptyUtil.isNoEmpty((Object)returnData)) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex("entry");
            int subRow = this.getModel().getEntryCurrentRowIndex("subentry");
            model.setValue("screensetting", returnData, subRow, row);
        } else if ("conditiondesc".equals(actionId)) {
            ExpressionFromHelper.dealCallbackOfCloseForm((ClosedCallBackEvent)event, (String)"conditiondesc", (String)"condition_tag", (AbstractFormPlugin)this);
        }
    }

    public void cellClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        if ("screensettingdesc".equals(fieldKey)) {
            this.showDiagnosisItemForm();
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void showDiagnosisItemForm() {
        IDataModel model = this.getModel();
        int rowEntry = model.getEntryCurrentRowIndex("entry");
        int rowSubEntry = model.getEntryCurrentRowIndex("subentry");
        String screenItem = (String)model.getValue("screenitem", rowSubEntry, rowEntry);
        IFormView view = this.getView();
        if (EmptyUtil.isBlank((CharSequence)screenItem)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7b5b\u67e5\u9879\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RiskScreenEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (TmcViewInputHelper.checkMustInput((IFormView)view, (IDataModel)model, (boolean)false, (String)"billentity")) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("fcs_riskdiagitem");
            parameter.setAppId(TmcFormHelper.getAppId((String)"fcs_riskdiagitem"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            String appBill = model.getDataEntity().getDynamicObject("billentity").getString("number");
            Object screenSetting = model.getValue("screensetting", rowSubEntry, rowEntry);
            if (EmptyUtil.isNoEmpty((Object)screenSetting)) {
                parameter.setPkId(screenSetting);
            } else {
                parameter.setCustomParam("appbill", (Object)appBill);
                parameter.setCustomParam("screenitem", (Object)screenItem);
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "screensettingdesc"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey;
        super.entryRowClick(evt);
        Object source = evt.getSource();
        if (source instanceof CardEntry && "entry".equals(entryKey = ((CardEntry)source).getEntryKey())) {
            this.setTempTypeName();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IPageCache pageCache;
        String toDelItems;
        super.afterDoOperation(args);
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess() && "save".equals(args.getOperateKey()) && EmptyUtil.isNotBlank((CharSequence)(toDelItems = (pageCache = this.getPageCache()).get(TODEL_ITEM)))) {
            Set delList = Arrays.stream(StringUtils.split((String)toDelItems, (String)",")).map(Long::valueOf).collect(Collectors.toSet());
            DeleteServiceHelper.delete((String)"fcs_riskdiagitem", (QFilter[])new QFilter("id", "in", delList).toArray());
        }
    }
}

