/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fcs.common.helper.RiskLogHelper;

public class RiskScreenLogList
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final Object billNo = this.getView().getFormShowParameter().getCustomParam("billno");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dataCollection = super.getData(start, limit);
                dataCollection.forEach(t -> t.set("billno", billNo));
                return dataCollection;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"fcs_riskscreen_log", (String)"billtext_tag", (QFilter[])new QFilter("id", "=", billList.getFocusRowPkId()).toArray());
        this.openFormByField(fieldName, dyn);
    }

    private void openFormByField(String fieldName, DynamicObject log) {
        if ("screenbatchid".equals(fieldName)) {
            List billIds = RiskLogHelper.unzipBillList((String)log.getString("billtext_tag"));
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fcs_riskbill_log");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)billIds));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

