/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;
import kd.tmc.fcs.common.enums.RiskResultEnum;
import kd.tmc.fcs.common.helper.RiskServiceHelper;

public class RiskTradePlatformPlugin
extends AbstractTmcDyncListPlugin
implements HyperLinkClickListener,
RowClickEventListener,
SetFilterListener,
ListRowClickListener {
    private static final String[] COLOR = new String[]{"#3987ED", "#9A4DFF", "#3DCCC0", "#FFB44A", "#FFD52E", "#F90D58", "#99D92B", "#85B8FF", "#FF854D", "#45CDFF", "#FF5257", "#40BD6E"};
    protected List<Long> selectedOrgIdList = new ArrayList<Long>(10);
    protected List<DynamicObject> accountBankList;
    protected FilterContainerInitArgs initArgs;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entry");
        entrysGrid.addRowClickListener((RowClickEventListener)this);
        BillList billlistid = (BillList)this.getControl("billlistap");
        billlistid.addHyperClickListener((HyperLinkClickListener)this);
        billlistid.addListRowClickListener((ListRowClickListener)this);
        billlistid.addSetFilterListener((SetFilterListener)this);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.addClickListener((ClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList billlistid = (BillList)this.getControl("billlistap");
        billlistid.setEntryEntity("subentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billlistid = (BillList)this.getControl("billlistap");
        billlistid.selectRows(0);
    }

    public void filterContainerInit(FilterContainerInitEvent args) {
        super.filterContainerInit(args);
        this.initArgs = new FilterContainerInitArgs(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"company.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue(null);
        }
        IPageCache pageCache = this.getPageCache();
        if (EmptyUtil.isEmpty((String)pageCache.get("isPageOpen"))) {
            pageCache.put("isPageOpen", Boolean.TRUE.toString());
            ArrayList<QFilter> qFilterStrList = new ArrayList<QFilter>(10);
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!"biztime".equals(fieldName)) continue;
                QFilter qFilter = new QFilter("biztime", ">=", (Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate()));
                qFilter.and("biztime", "<=", (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate()));
                qFilterStrList.add(qFilter);
            }
            Map<String, List<Object>> filterMap = args.getCommonFilterColumns().stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.getFilterColumns())).collect(Collectors.toMap(FilterColumn::getFilterFieldName, FilterColumn::getDefaultValues, (p, q) -> p));
            this.accountBankList = this.getAccountBankList(filterMap);
            qFilterStrList.addAll(this.setCommonFilter(filterMap));
            List stringList = qFilterStrList.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            pageCache.put("qfilters", SerializationUtils.toJsonString(stringList));
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        Object clickFieldName;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        for (QFilter qFilter : event.getFilterParameter().getQFilters()) {
            this.addFilterWithNest(qFilter, qFilterList);
        }
        Map filtervalue = event.getFilterValues();
        List customfilterList = (List)filtervalue.get("customfilter");
        List fastfilter = (List)filtervalue.get("fastfilter");
        HashMap<String, List<Object>> customfilterMap = new HashMap<String, List<Object>>(16);
        if (customfilterList != null) {
            for (Map map : customfilterList) {
                if (((List)map.get("Value")).size() == 1 && StringUtils.equals((CharSequence)"", (CharSequence)((List)map.get("Value")).get(0).toString())) continue;
                customfilterMap.put(((List)map.get("FieldName")).get(0).toString(), (List<Object>)map.get("Value"));
            }
        }
        this.accountBankList = this.getAccountBankList(customfilterMap);
        if (event.getCurrentCommonFilter() != null && "company.id".equals(clickFieldName = ((List)event.getCurrentCommonFilter().get("FieldName")).get(0).toString())) {
            customfilterMap.put("account.id", null);
        }
        filtervalue.put("customfilter", new ArrayList());
        qFilterList.addAll(this.setCommonFilter(customfilterMap));
        if (!EmptyUtil.isEmpty((Collection)fastfilter)) {
            for (Map map : fastfilter) {
                List values = (List)map.get("Value");
                if (null == values || values.size() <= 0) continue;
                QFilter billFilter = null;
                for (Object value : values) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('%');
                    sb.append(value);
                    sb.append('%');
                    if (billFilter == null) {
                        billFilter = new QFilter("billno", "like", (Object)sb.toString());
                        continue;
                    }
                    billFilter = billFilter.or(new QFilter("billno", "like", (Object)sb.toString()));
                }
                qFilterList.add(billFilter);
            }
        }
        List qFilterStrList = qFilterList.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        this.getPageCache().put("qfilters", SerializationUtils.toJsonString(qFilterStrList));
        this.fillPageData();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List qfilters = args.getQfilters();
        List cacheFilter = this.getQFilterFromPagCache();
        if (null != cacheFilter) {
            Map filterMap = cacheFilter.stream().collect(Collectors.toMap(QFilter::getProperty, Function.identity(), (p, q) -> p));
            QFilter orgFilter = (QFilter)filterMap.get("company.id");
            if ("account.id".equals(fieldName)) {
                if (Objects.nonNull(orgFilter)) {
                    qfilters.add(orgFilter);
                } else {
                    qfilters.add(new QFilter("company.id", "in", this.getHasPermOrg()));
                }
            }
        }
    }

    protected List<Long> filterValueToLongList(List<Object> objectList) {
        return Optional.ofNullable(objectList).orElseGet(Collections::emptyList).stream().filter(StringUtils::isNotBlank).map(t -> Long.parseLong(t.toString())).collect(Collectors.toList());
    }

    protected List<QFilter> setCommonFilter(Map<String, List<Object>> customfilterMap) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        this.selectedOrgIdList = this.filterValueToLongList(customfilterMap.get("company.id"));
        List<ComboItem> bankNumberItems = this.initAcctItemsList();
        for (FilterColumn filterColumn : this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "company.name": {
                    if (!EmptyUtil.isEmpty((Collection)customfilterMap.get("company.id"))) {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("company.id"));
                    } else {
                        commonFilterColumn.setDefaultValues(new ArrayList());
                    }
                    if (EmptyUtil.isEmpty((Collection)commonFilterColumn.getDefaultValues())) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().map(o -> o == null ? 0L : Long.parseLong(o.toString())).collect(Collectors.toList());
                    qFilterList.add(new QFilter("company.id", "in", listLong));
                    break;
                }
                case "account.bankaccountnumber": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(bankNumberItems);
                    if (EmptyUtil.isEmpty((Collection)customfilterMap.get("account.id"))) {
                        if (commonFilterColumn.isMustInput() && bankNumberItems.size() > 0) {
                            commonFilterColumn.setDefaultValues(new Object[]{bankNumberItems.get(0).getValue()});
                        } else {
                            commonFilterColumn.setDefaultValues(new Object[]{""});
                        }
                    } else {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("account.id"));
                    }
                    if (EmptyUtil.isEmpty(commonFilterColumn.getDefaultValues().get(0))) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().map(o -> o == null ? 0L : Long.parseLong(o.toString())).collect(Collectors.toList());
                    qFilterList.add(new QFilter("account.id", "in", listLong));
                    break;
                }
                case "biztime": {
                    commonFilterColumn.setDefaultValues(customfilterMap.get("biztime"));
                    break;
                }
            }
        }
        return qFilterList;
    }

    private List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (EmptyUtil.isNoEmpty(this.accountBankList)) {
            for (DynamicObject cashAcct : this.accountBankList) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    protected void fillPageData() {
        this.fillPageData(this.getQFilterFromPagCache());
    }

    protected String getEntityName() {
        return "fcs_errordata_layout";
    }

    public void fillPageData(List<QFilter> qFilters) {
        this.checkAddOrg(qFilters);
        String selectFields = "id,entry.typename as typename,result";
        DynamicObjectCollection errorDatas = QueryServiceHelper.query((String)"fcs_errordata", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"modifytime desc");
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.setFilter(new QFilter("id", "in", errorDatas.stream().map(s -> s.getLong("id")).collect(Collectors.toSet())));
        billlistap.refresh();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)errorDatas)) {
            Map<String, List<DynamicObject>> collect = errorDatas.stream().filter(o -> !RiskResultEnum.NORMAL_TRADE.getValue().equals(o.getString("result")) && EmptyUtil.isNoEmpty((String)o.getString("typename"))).collect(Collectors.groupingBy(s -> s.getString("typename")));
            Map<String, Integer> sortMap = RiskTradePlatformPlugin.sortMap(collect);
            this.drawCardInfo(errorDatas, sortMap);
            this.drawPieChart(sortMap, true);
            BillList billlistid = (BillList)this.getControl("billlistap");
            billlistid.selectRows(0);
        } else {
            selectFields = "entry.typename as typename";
            QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            DynamicObjectCollection riskModel = QueryServiceHelper.query((String)"fcs_riskscreening", (String)selectFields, (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)riskModel)) {
                Map<String, Integer> sortMap = this.dealRiskModel(riskModel);
                this.drawCardInfo(errorDatas, sortMap);
                this.drawPieChart(sortMap, false);
            } else {
                this.clearCardAndPieChart();
            }
            BillList billlistid = (BillList)this.getControl("billlistap");
            ListSelectedRow currenRow = billlistid.getCurrentSelectedRowInfo();
            if (currenRow != null) {
                billlistid.removeSelectRow(currenRow.toString());
            }
            this.dorwFloatLayer();
        }
    }

    private Map<String, Integer> dealRiskModel(DynamicObjectCollection riskModel) {
        Map<String, Integer> sortMap = riskModel.stream().collect(Collectors.groupingBy(s -> s.getString("typename"), Collectors.summingInt(s -> 0)));
        if (sortMap.size() > 6) {
            return sortMap.entrySet().stream().limit(6L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return sortMap;
    }

    private void drawCardInfo(DynamicObjectCollection errorDatas, Map<String, Integer> sortMap) {
        int carSeq = 1;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("image", new Object[0]);
        vs.addField("cardseq", new Object[0]);
        vs.addField("count", new Object[0]);
        vs.addField("cardtypename", new Object[0]);
        vs.addField("ids", new Object[0]);
        for (Map.Entry<String, Integer> integerEntry : sortMap.entrySet()) {
            String typeName = integerEntry.getKey();
            Integer count = integerEntry.getValue();
            List errorIds = errorDatas.stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getString("typename")) && typeName.equals(o.getString("typename"))).map(s -> s.getLong("id")).collect(Collectors.toList());
            String realPath = UrlService.getDomainContextUrl() + "/kingdee/tmc/images/pc/icon/lable/zjy_risk" + carSeq + "_40_40.png";
            vs.addRow(new Object[]{realPath, "NO." + carSeq, String.valueOf(count), typeName, SerializationUtils.toJsonString(errorIds)});
            ++carSeq;
        }
        model.batchCreateNewEntryRow("entry", vs);
        model.endInit();
        this.getView().updateView("entry");
    }

    private void drawPieChart(Map<String, Integer> sortMap, boolean isHaveData) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.createSeries("fcs_risktrade_platform");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u5f02\u5e38\u6570\u636e\u5206\u5e03", (String)"RiskTradePlatformPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        series.setType(ChartType.pie);
        Label label = new Label();
        label.setShow(isHaveData);
        label.setFormatter("{d}%");
        series.setLabel(label);
        HashMap<String, Boolean> labelLine = new HashMap<String, Boolean>(4);
        labelLine.put("show", isHaveData);
        series.setPropValue("labelLine", labelLine);
        if (isHaveData) {
            series.setRadius("40%", "70%");
        } else {
            series.setRadius("40%", "80%");
        }
        ArrayList<ItemValue> items = new ArrayList<ItemValue>(10);
        int carSeq = 1;
        for (Map.Entry<String, Integer> integerEntry : sortMap.entrySet()) {
            Integer count = integerEntry.getValue();
            items.add(new ItemValue("NO." + carSeq + integerEntry.getKey(), (Number)count, COLOR[carSeq - 1]));
            ++carSeq;
        }
        series.setData(items.toArray(new ItemValue[0]));
        pieChart.refresh();
    }

    private void clearCardAndPieChart() {
        this.getModel().deleteEntryData("entry");
        this.getView().updateView("entry");
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.refresh();
    }

    public static Map<String, Integer> sortMap(Map<String, List<DynamicObject>> map) {
        ArrayList<Map.Entry<String, List<DynamicObject>>> entryList = new ArrayList<Map.Entry<String, List<DynamicObject>>>(map.entrySet());
        entryList.sort((o1, o2) -> ((List)o2.getValue()).size() - ((List)o1.getValue()).size());
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : entryList) {
            linkedHashMap.put((String)entry.getKey(), ((List)entry.getValue()).size());
        }
        return linkedHashMap;
    }

    public void click(EventObject evt) {
        String name;
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("piechartap") && (name = ((ChartClickEvent)evt).getName()) != null) {
            String index = name.substring(3, 4);
            this.showErrorDataByIndex(Integer.parseInt(index) - 1);
        }
    }

    private void addFilterWithNest(QFilter qFilter, List<QFilter> qFilterList) {
        List nests;
        if ("biztime".equals(qFilter.getProperty())) {
            qFilterList.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)(nests = qFilter.getNests(true)))) {
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (!"biztime".equals(nestFilter.getProperty())) continue;
                qFilterList.add(new QFilter(nestFilter.getProperty(), nestFilter.getCP(), nestFilter.getValue()));
            }
        }
    }

    protected List<DynamicObject> getAccountBankList(Map<String, List<Object>> filterMap) {
        List<Long> orgList = this.filterValueToLongList(filterMap.get("company.id"));
        String selectProperties = "id,name,number,defaultcurrency.id,bankaccountnumber,defaultcurrency.name,currency.fbasedataid.*,bank,bank.bank_cate,bank.finorgtype";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (EmptyUtil.isNoEmpty(orgList)) {
            qfilters.add(new QFilter("company.id", "in", orgList));
        } else {
            qfilters.add(new QFilter("company.id", "in", this.getHasPermOrg()));
        }
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        List<Object> list = new ArrayList(BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0])).values());
        list = list.stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get("bank.finorgtype"))).collect(Collectors.toList());
        list.sort(Comparator.comparing(t -> t.getString("bank.finorgtype.number")));
        return list;
    }

    private void checkAddOrg(List<QFilter> qFilters) {
        List<Object> orgList;
        boolean hasOrg = qFilters.stream().anyMatch(t -> "company.id".equals(t.getProperty()));
        if (!hasOrg && EmptyUtil.isNoEmpty(orgList = this.getHasPermOrg())) {
            qFilters.add(new QFilter("company.id", "in", orgList));
            List stringList = qFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            this.getPageCache().put("qfilters", SerializationUtils.toJsonString(stringList));
        }
    }

    private List<Object> getHasPermOrg() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fcs_risktrade_platform", (String)"47150e89000000ac");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("refresh".equals(opKey)) {
            this.fillPageData();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject errorData;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("sharmtrade".equals(operate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.showDynamicWindow("fcs_real_screening", null);
        } else if ("analyse".equals(operate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess() && (errorData = this.getSelectedData(true)) != null) {
            String result = errorData.getString("result");
            if (!RiskResultEnum.SUSPECT_TRADE.getValue().equals(result)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7b5b\u67e5\u7ed3\u679c\u7b49\u4e8e\u7591\u4f3c\u865a\u5047\u4ea4\u6613\u624d\u5141\u8bb8\u8d22\u52a1\u4e13\u5bb6\u8865\u5145\u5206\u6790\u3002", (String)"RiskTradePlatformPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            } else {
                this.showDynamicWindow("fcs_sham_analyse", errorData.getLong("id"));
            }
        }
    }

    private void showDynamicWindow(String formId, Long selectedId) {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId(formId);
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCustomParam("id", (Object)selectedId);
        showForm.setCustomParam("pageId", (Object)this.getView().getPageId());
        showForm.setCustomParam("traceid", (Object)RequestContext.get().getTraceId());
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(showForm);
    }

    protected DynamicObject getSelectedData(boolean showMessage) {
        BillList billlistid = (BillList)this.getControl("billlistap");
        ListSelectedRow currenRow = billlistid.getCurrentSelectedRowInfo();
        if (currenRow != null) {
            Object errorId = currenRow.getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", errorId);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_errordata", (String)"id,billid,datatype.number as datatype, result", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)query)) {
                return (DynamicObject)query.get(0);
            }
            return null;
        }
        if (showMessage) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractTmcDyncListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("fcs_sham_analyse".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if ("fcs_real_screening".equals(actionId)) {
            Map data = (Map)event.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)data)) {
                JobFormInfo jobFormInfo = this.buildJobFormInfo(data);
                String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
                if (!TaskClientProxy.isExistTask((String)taskId)) {
                    TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                    TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                    BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                    ThreadPools.executeOnce((String)"tmc-fcs-risk-task-background-monitor", (Runnable)subscriber);
                }
                FormShowParameter sp = new FormShowParameter();
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fcs_real_progresstask"));
                RiskServiceHelper.showRealProgressTask((IFormView)this.getView(), (FormShowParameter)sp, (Map)data, (String)"auto", (String)taskId);
                this.getPageCache().put("alreadyShowTask", "true");
            }
        } else if ("fcs_real_progresstask".equals(actionId)) {
            this.getPageCache().remove("alreadyShowTask");
        }
    }

    private JobFormInfo buildJobFormInfo(Map<String, Object> data) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u5b9e\u65f6\u7b5b\u67e5\u8fdb\u5ea6\u8ddf\u8e2a", (String)"RiskTradePlatformPlugin_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.tmc.fcs.formplugin.task.risk.RiskRealProgressTaskImpl");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("billIdStr", data.get("billIdStr"));
        params.put("datatype", data.get("datatype"));
        params.put("startdate", data.get("startdate"));
        params.put("enddate", data.get("enddate"));
        params.put("datatypeid", data.get("datatypeid"));
        params.put("orgInfo", data.get("orgInfo"));
        params.put("startTime", data.get("startTime"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        CloseCallBack closeCallBack = new CloseCallBack("kd.tmc.fcs.formplugin.task.risk.RiskRealProgressCallBack", "background_actionid");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.tmc.fcs.formplugin.task.risk.RiskRealProgressClick");
        return jobFormInfo;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        DynamicObject rowData = this.getSelectedData(false);
        if (EmptyUtil.isNoEmpty((DynamicObject)rowData)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(rowData.getString("datatype"));
            showParameter.setPkId((Object)rowData.getLong("billid"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.dorwFloatLayer();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            this.showErrorDataByIndex(index);
        }
    }

    private void showErrorDataByIndex(int index) {
        String idStr = (String)this.getModel().getValue("ids", index);
        List ids = (List)SerializationUtils.fromJsonString((String)idStr, List.class);
        if (ids.size() > 0) {
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListShowParameter listShowParameter = new ListShowParameter();
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(idFilter);
            listShowParameter.setListFilterParameter(lfp);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setBillFormId("fcs_errordata");
            listShowParameter.setCustomParam("clearfilter", (Object)"true");
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void dorwFloatLayer() {
        DynamicObject errorData = this.getSelectedData(false);
        if (errorData != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fcs_float_layer");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexrisk");
            showParameter.setCustomParam("bizDataId", (Object)String.valueOf(errorData.getLong("billid")));
            showParameter.setCustomParam("entityNumber", (Object)errorData.getString("datatype"));
            showParameter.setCustomParam("errorDataId", (Object)errorData.getLong("id"));
            this.getView().showForm(showParameter);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setAppId("fcs");
            showParameter.setFormId("fcs_errordata_layout");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexrisk");
            this.getView().showForm(showParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().addAll(this.getQFilterFromPagCache());
    }
}

