/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.risk;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.BillOperationHelper;
import kd.tmc.fcs.common.property.OpreatTypeProp;

public class RiskTradeWarnEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        this.setWarnOperationComboItem();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        IFormView view = this.getView();
        String propkey = e.getProperty().getName();
        if ("billentity".equals(propkey)) {
            this.setWarnOperationComboItem();
            model.setValue("warnop", null);
        } else if ("smartinsight".equals(propkey)) {
            if (dataEntity.getBoolean("smartinsight")) {
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)true, (String[])new String[]{"smartsetting"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)false, (String[])new String[]{"smartsetting"});
                model.setValue("smartsetting", null);
            }
        } else if ("dataanalysis".equals(propkey)) {
            if (dataEntity.getBoolean("dataanalysis")) {
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)true, (String[])new String[]{"riskscreening"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)false, (String[])new String[]{"riskscreening"});
                model.setValue("riskscreening", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            this.validSave(args);
        }
    }

    private void setWarnOperationComboItem() {
        DynamicObject billEntity = (DynamicObject)this.getModel().getValue("billentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)billEntity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)billEntity.getString("number"), (List)OpreatTypeProp.RISK_TRADE_WARN_LIST, (String[])new String[]{"warnop"});
        }
    }

    private void validSave(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isSmart = dataEntity.getBoolean("smartinsight");
        boolean isDataAnal = dataEntity.getBoolean("dataanalysis");
        if (isSmart && !TmcViewInputHelper.checkMustInput((IFormView)view, (IDataModel)model, (boolean)false, (String)"smartsetting")) {
            args.setCancel(true);
        }
        if (isDataAnal && !TmcViewInputHelper.checkMustInput((IFormView)view, (IDataModel)model, (boolean)false, (String)"riskscreening")) {
            args.setCancel(true);
        }
        if (!isSmart && !isDataAnal) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u667a\u80fd\u6d1e\u5bdf\u201d\u3001\u201c\u5927\u6570\u636e\u5206\u6790\u201d\u5fc5\u987b\u5f00\u542f\u4e00\u4e2a\u4ee5\u4e0a\u3002", (String)"RiskTradeWarnEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

