/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.safetyinspect;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;

public class InputReasonPlugin
extends AbstractTmcDyncListPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SELECTFIELDS = "repeatentry.id id,customer,tenantname,bizdate,repeatentry.srcbillentityname srcbillentityname,repeatentry.destbillentityname destbillentityname,repeatentry.pushtype pushtype,repeatentry.count count,repeatentry.dealer dealer,repeatentry.dealtime dealtime,repeatentry.reasontype reasontype,repeatentry.reason reason,repeatentry.reason_tag reason_tag,repeatentry.contacter contacter,repeatentry.contacterphone contacterphone";
    private List<QFilter> qFilters = new ArrayList<QFilter>(10);

    public void filterContainerInit(FilterContainerInitEvent event) {
        super.filterContainerInit(event);
        if (this.getPageCache().get("isFirstInit") == null) {
            this.getPageCache().put("isFirstInit", "true");
            Date date = new Date();
            this.qFilters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)date, (int)1), (boolean)true)).and("bizdate", "<", (Object)DateUtils.truncateDate((Date)date)));
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        super.filterSearchClickEvent(event);
        this.qFilters = event.getFastQFilters();
        this.qFilters.add(event.getQFilter("bizdate"));
        this.fillPageData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity(ENTRYENTITY);
        if ("save".equals(opKey)) {
            Map<Integer, List<DynamicObject>> needUpdateRows = entrys.stream().filter(r -> r.getBoolean("inputandnosave")).collect(Collectors.groupingBy(r -> r.getInt("seq")));
            String sql = "update t_fcs_safetyinspect_r set fdealer = ? ,fdealtime = ? ,freasontype = ? ,freason = ? ,freason_tag = ?,fcontacter = ?,fcontacterphone = ? where fentryid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(needUpdateRows.size());
            for (Map.Entry<Integer, List<DynamicObject>> needUpdateRow : needUpdateRows.entrySet()) {
                Object[] params = new Object[8];
                DynamicObject r2 = needUpdateRow.getValue().get(0);
                params[0] = r2.getString("dealer");
                params[1] = r2.getDate("dealtime");
                params[2] = r2.getString("reasontype");
                params[3] = r2.getString("reason");
                params[4] = r2.getString("reason_tag");
                params[5] = r2.getString("contacter");
                params[6] = r2.getString("contacterphone");
                params[7] = r2.getLong("id");
                paramList.add(params);
                this.getModel().setValue("inputandnosave", (Object)false, needUpdateRow.getKey() - 1);
            }
            if (EmptyUtil.isNoEmpty(paramList)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"tmc"), (String)sql, paramList);
            }
        } else if ("setwhite".equals(opKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            HashSet<String> selectTenants = new HashSet<String>(8);
            for (int selectRow : selectRows) {
                byte[] bytes;
                String tenant = (String)this.getModel().getValue("tenantname", selectRow);
                if (!EmptyUtil.isNoEmpty((String)tenant) || (bytes = tenant.getBytes()).length != tenant.length()) continue;
                selectTenants.add(tenant);
            }
            DynamicObjectCollection whites = QueryServiceHelper.query((String)"fcs_tenantwhite", (String)"id,tenant", (QFilter[])new QFilter[]{new QFilter("tenant", "in", selectTenants)});
            if (whites.size() > 0) {
                Set tenant = whites.stream().map(w -> w.getString("tenant")).collect(Collectors.toSet());
                selectTenants.removeAll(tenant);
            }
            ArrayList<DynamicObject> newWhites = new ArrayList<DynamicObject>(10);
            for (String tenant : selectTenants) {
                DynamicObject newWhite = BusinessDataServiceHelper.newDynamicObject((String)"fcs_tenantwhite");
                newWhite.set("tenant", (Object)tenant);
                newWhites.add(newWhite);
            }
            if (newWhites.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])newWhites.toArray(new DynamicObject[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        switch (name) {
            case "dealer": 
            case "dealtime": 
            case "reasontype": 
            case "reason": 
            case "reason_tag": 
            case "contacter": 
            case "contacterphone": {
                this.getModel().setValue("inputandnosave", (Object)true, entryCurrentRowIndex);
                break;
            }
        }
    }

    protected void fillPageData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.qFilters.add(new QFilter("repeatentry.pushtype", "!=", (Object)" "));
        DynamicObjectCollection repeatDatas = QueryServiceHelper.query((String)"fcs_safetyinspect", (String)SELECTFIELDS, (QFilter[])this.qFilters.toArray(new QFilter[0]), (String)"bizdate desc");
        model.deleteEntryData(ENTRYENTITY);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]).addField("tenantname", new Object[0]).addField("customer", new Object[0]).addField("bizdate", new Object[0]).addField("srcbillentityname", new Object[0]).addField("destbillentityname", new Object[0]).addField("pushtype", new Object[0]).addField("count", new Object[0]).addField("dealer", new Object[0]).addField("dealtime", new Object[0]).addField("reasontype", new Object[0]).addField("reason", new Object[0]).addField("reason_tag", new Object[0]).addField("contacter", new Object[0]).addField("contacterphone", new Object[0]);
        for (DynamicObject row : repeatDatas) {
            vs.addRow(new Object[]{row.getLong("id"), row.getString("tenantname"), row.getString("customer"), row.getDate("bizdate"), row.getString("srcbillentityname"), row.getString("destbillentityname"), row.getString("pushtype"), row.getString("count"), row.getString("dealer"), row.getDate("dealtime"), row.getString("reasontype"), row.getString("reason"), row.getString("reason_tag"), row.getString("contacter"), row.getString("contacterphone")});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    protected String getEntityName() {
        return "fcs_safetyinspect";
    }
}

