/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTodayStatusEnum;

public class ScheExecItem
implements Serializable {
    private Long scheduleId;
    private Date execTime;
    private String execResult;
    private Long taskId;
    private int hourArea;
    private int count;

    public ScheExecItem(Long scheduleId, Date execTime, String execResult, Long taskId) {
        this.scheduleId = scheduleId;
        this.execTime = execTime;
        this.execResult = EmptyUtil.isBlank((CharSequence)execResult) ? ScheduleTodayStatusEnum.PROCESSING.getValue() : execResult;
        this.taskId = taskId;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(execTime);
        this.hourArea = calendar.get(11) / 4;
        this.count = 1;
    }

    public ScheExecItem(Long scheduleId, Date execTime, int count) {
        this.scheduleId = scheduleId;
        this.execTime = execTime;
        this.execResult = ScheduleTodayStatusEnum.TOBESTARTED.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(execTime);
        this.hourArea = calendar.get(11) / 4;
        this.count = count;
    }

    public Long getScheduleId() {
        return this.scheduleId;
    }

    public Date getExecTime() {
        return this.execTime;
    }

    public String getExecResult() {
        return this.execResult;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public int getHourArea() {
        return this.hourArea;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

