/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;

public class ScheParamList
extends AbstractTmcListPlugin {
    private static final Log logger = LogFactory.getLog(ScheParamList.class);
    private static final String CACHE_NEWFORM = "newForm";
    private static final String SCHEDULE_PARAM_FIELDS = "FID,FBUSSINESS,FMASTERID,FSTATUS,FCLASSNAMEID,FNUMBER,FNAME,FOPERATEKEY,FCREATETIME,FENABLE,FBIZAPP,FMODIFYTIME,FTASKTYPE";
    private static final String SCHEDULE_PARAM_L_FIELDS = "FID,FPKID,FLOCALEID,FCOMMENT,FNAME";
    private static final String SCHEDULE_ENTRY_FIELDS = "FID,FREQUIRE,FPARAMTYPE,FPARAMVAL,FENTRYID,FSEQ,FPARAM";
    private static final String SCHEDULE_ENTRY_L_FIELDS = "FPKID,FLOCALEID,FPARAMDESC,FCOMBOVAL,FENTRYID,FPARAMNAME";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IPageCache pageCache = this.getPageCache();
        if ("operate".equals(evt.getItemKey())) {
            pageCache.put(CACHE_NEWFORM, "fcs_schedule_operparam");
        } else if ("task".equals(evt.getItemKey())) {
            pageCache.put(CACHE_NEWFORM, "fcs_schdule_taskparam");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String newForm = this.getPageCache().get(CACHE_NEWFORM);
        if (EmptyUtil.isNotBlank((CharSequence)newForm)) {
            this.getPageCache().remove(CACHE_NEWFORM);
            e.getParameter().setFormId(newForm);
        } else {
            DynamicObject object = TmcDataServiceHelper.loadSingleFromCache((Object)e.getParameter().getPkId(), (String)"fcs_schedule_param");
            String taskType = object.getString("tasktype");
            if (ScheduleTaskTypeEnum.isOperation((String)taskType)) {
                e.getParameter().setFormId("fcs_schedule_operparam");
            } else if (ScheduleTaskTypeEnum.isJob((String)taskType)) {
                e.getParameter().setFormId("fcs_schdule_taskparam");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("exportksql".equals(itemKey)) {
            this.downloadKsql();
        }
    }

    private void downloadKsql() {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isNoEmpty((Object)selectedIdList)) {
            String content = this.getParamKsql(selectedIdList);
            try (BufferedInputStream bin = new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
                Map aut = TmcAttachmentHelper.newModelTempFile((String)"scheduleparam.sql", (String)"sql", (InputStream)bin, (String)DBServiceHelper.genStringId(), (String)"fcs_schedule_param");
                this.getView().download(aut.get("url").toString());
            }
            catch (IOException e) {
                logger.error("content error", (Throwable)e);
            }
        }
    }

    private String getParamKsql(List<Long> ids) {
        StringBuilder builder = new StringBuilder();
        Map params = TmcDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"fcs_schedule_param");
        for (DynamicObject param : params.values()) {
            Object pkValue = param.getPkValue();
            builder.append(this.exportKsql("t_fcs_scheduleparam", SCHEDULE_PARAM_FIELDS, this.formatId("FID", pkValue))).append("\n");
            builder.append(this.exportKsql("T_FCS_SCHEDULEPARAM_L", SCHEDULE_PARAM_L_FIELDS, this.formatId("FID", pkValue))).append("\n");
            DynamicObjectCollection entrys = param.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) continue;
            builder.append(this.exportKsql("T_FCS_SCHPARAMENTRY", SCHEDULE_ENTRY_FIELDS, this.formatId("FID", pkValue))).append("\n");
            for (DynamicObject pe : entrys) {
                builder.append(this.exportKsql("T_FCS_SCHPARAMENTRY_L", SCHEDULE_ENTRY_L_FIELDS, this.formatId("FENTRYID", pe.getPkValue()))).append("\n");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private String formatId(String filterId, Object pkValue) {
        return String.format(filterId + " = '%s'", pkValue);
    }

    private String exportKsql(String tableName, String fields, String where) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRouteConst.TMC, tableName, fields, where, null, null);
        return (String)map.get("sql");
    }
}

