/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.instance.AppGroup;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.tmc.fcs.common.helper.ScheduleTaskHelper;

public class ScheParamTreeList
extends StandardTreeListPlugin {
    private static final String NUMBER_LIST = "numberList";
    private static final String TASKCLASSNAME_APPID = "classname.appid";
    private static final String BIZAPP_NUMBER = "bizapp.number";
    private static final String ROOT_NODE_ID = "-1";
    private static final String NODE_TYPE_CLOUD = "cloud";
    private static final String NODE_TYPE_APP = "app";
    private List<AppInfo> grayAppInfoList = null;

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 3);
        e.setChildNodes(currentNode.getChildren());
    }

    private TreeNode loadAllAppNodes() {
        TreeNode root = new TreeNode();
        JSONObject map = new JSONObject();
        map.put("type", (Object)"root");
        root.setId(ROOT_NODE_ID);
        root.setData((Object)map);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ScheTaskParamList_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        if (!cloudNodes.isEmpty()) {
            root.setChildren(cloudNodes);
        }
        return root;
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeView");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        ((ListView)this.getView()).setNeedRefreshTree(false);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getTreeListView().getTreeModel().setRoot(this.loadAllAppNodes());
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        if (ROOT_NODE_ID.equals(nodeId)) {
            return;
        }
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 2);
        Map nodeData = (Map)current.getData();
        String nodeType = (String)nodeData.get("type");
        QFilter qFilter = null;
        if (NODE_TYPE_CLOUD.equals(nodeType)) {
            if (current.getChildren() != null && !current.getChildren().isEmpty()) {
                ArrayList apps = new ArrayList(10);
                for (TreeNode node : current.getChildren()) {
                    Map data = (Map)node.getData();
                    List appNumbers = (List)data.get(NUMBER_LIST);
                    apps.addAll(appNumbers);
                }
                qFilter = new QFilter(TASKCLASSNAME_APPID, "in", apps).or(BIZAPP_NUMBER, "in", apps);
            } else {
                qFilter = new QFilter(TASKCLASSNAME_APPID, "in", (Object)"noappid");
            }
        } else if (NODE_TYPE_APP.equals(nodeType)) {
            Map data = (Map)current.getData();
            List appNumbers = (List)data.get(NUMBER_LIST);
            ArrayList apps = new ArrayList(appNumbers);
            qFilter = new QFilter(TASKCLASSNAME_APPID, "in", apps).or(BIZAPP_NUMBER, "in", apps);
        }
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, (String[])ScheduleTaskHelper.getApps().toArray(new String[0]), null, (String)NODE_TYPE_APP);
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(10);
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String cloudId = appInfo.getCloudId();
                String appId = appInfo.getId();
                TreeNode cloudNode = root.getTreeNode(cloudId, 5);
                TreeNode appNode = root.getTreeNode(appId, 5);
                if (cloudNode == null || appNode != null) continue;
                ArrayList<TreeNode> appTreeNodes = cloudNode.getChildren();
                if (appTreeNodes == null) {
                    appTreeNodes = new ArrayList<TreeNode>(10);
                    cloudNode.setChildren(appTreeNodes);
                }
                appTreeNodes.add(new TreeNode(cloudId, appId, appInfo.getName().toString()));
            }
        }
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>(16);
        HashMap<String, List<String>> appNumIndex = new HashMap<String, List<String>>(16);
        this.getOriginExtendAppRelMap(originExtendAppRelMap, appNumIndex);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            HashMap<String, String> cloudData = new HashMap<String, String>(16);
            cloudData.put("type", NODE_TYPE_CLOUD);
            String cloudNodeId = "cloud_" + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData(cloudData);
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                HashMap<String, String> appData = new HashMap<String, String>(16);
                appData.put("type", NODE_TYPE_APP);
                String appNodeId = "app_" + app.getId();
                String masterId = (String)originExtendAppRelMap.get(appNodeId);
                appData.put(NUMBER_LIST, (String)appNumIndex.get(masterId));
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData(appData);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private void getOriginExtendAppRelMap(Map<String, String> originExtendAppRelMap, Map<String, List<String>> appNumIndex) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String number = app.getString("number");
            String appId = app.getString("id");
            String nodeId = "app_" + appId;
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                this.addToList(appNumIndex, nodeId, number);
                continue;
            }
            String masterId = app.getString("masterid");
            String masterNodeId = "app_" + masterId;
            originExtendAppRelMap.put(nodeId, masterNodeId);
            this.addToList(appNumIndex, masterNodeId, number);
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String nodeId = "app_" + appInfo.getId();
                originExtendAppRelMap.put(nodeId, nodeId);
                this.addToList(appNumIndex, nodeId, appInfo.getNumber());
            }
        }
    }

    private void addToList(Map<String, List<String>> appNumIndex, String key, String value) {
        if (appNumIndex.get(key) != null) {
            appNumIndex.get(key).add(value);
        } else {
            ArrayList<String> list = new ArrayList<String>(10);
            list.add(value);
            appNumIndex.put(key, list);
        }
    }

    private List<AppInfo> getGrayAppInfos() {
        if (this.grayAppInfoList != null) {
            return this.grayAppInfoList;
        }
        this.grayAppInfoList = new ArrayList<AppInfo>(10);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        if (AppGroup.isGrayUpgrade()) {
            List appInfoStrList = metadataService.loadGrayAppInfoList();
            for (String infoStr : appInfoStrList) {
                if (StringUtils.isBlank((CharSequence)infoStr)) continue;
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
                this.grayAppInfoList.add(appInfo);
            }
        }
        return this.grayAppInfoList;
    }
}

