/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.helper.ConditionHelper;
import kd.tmc.fcs.common.helper.ScheduleBussinessOperateHelper;

public class ScheduleBussOperEdit
extends TmcBaseDataEdit
implements BeforeF7SelectListener {
    private static final String ADD_TASK = "addtask";
    private static final String MODIFY_TASK = "modifytask";
    private static final String SPLIT_STR = ":";
    private static final String MODIFY_INDEX = "modifyIndex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("status"))) {
            this.addClickListeners(new String[]{"bizfilter", "addcard", "addimg", "addlabel", "deletetlap", "modifilap", "addorg"});
        }
        BasedataEdit bizApp = (BasedataEdit)this.getControl("bizapp");
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        switch (propName) {
            case "bizapp": {
                this.initBizAppFilter(evt);
                break;
            }
            case "org": {
                sp.setMultiSelect(Boolean.TRUE.booleanValue());
                sp.getListFilterParameter().getQFilters().add(this.getSelectOrgQFilter());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "bizapp": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    ScheduleBussinessOperateHelper.setBussinessComboItems((String)((DynamicObject)newValue).getString("id"), (IFormView)this.getView());
                }
                this.getModel().setValue("bussiness", null);
                this.getModel().setValue("bizfilterconfig_tag", null);
                this.getModel().setValue("bizfilter", null);
                this.clearTaskEntry();
                break;
            }
            case "bizfilter": {
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                this.getModel().setValue("bizfilterconfig_tag", null);
                break;
            }
            case "bussiness": {
                this.getModel().setValue("bizfilterconfig_tag", null);
                this.getModel().setValue("bizfilter", null);
                this.clearTaskEntry();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("tasktype", (Object)ScheduleTaskTypeEnum.OPERATION.getValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"tasktype"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"bizapp", "bussiness"});
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizApp)) {
            ScheduleBussinessOperateHelper.setBussinessComboItems((String)bizApp.getString("id"), (IFormView)this.getView());
            String bussiness = (String)this.getModel().getValue("bussiness");
            this.getModel().setValue("bussiness", (Object)bussiness);
        }
        this.showTaskEntryParam();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("addorg".equals(args.getOperateKey())) {
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setBillFormId("bos_org");
            para.setFormId("bos_orgtreelistf7");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowTitle(false);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addorg"));
            para.getListFilterParameter().getQFilters().add(this.getSelectOrgQFilter());
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control button;
        String field;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Control && ("addimg".equals(field = (button = (Control)source).getKey()) || "addlabel".equals(field) || "addcard".equals(field))) {
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
            String bussiness = (String)this.getModel().getValue("bussiness");
            if (EmptyUtil.isEmpty((DynamicObject)bizApp) || EmptyUtil.isEmpty((String)bussiness)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5e94\u7528\u548c\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ScheduleBussOperEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String proKey = source.getKey();
        String bussiness = (String)this.getModel().getValue("bussiness");
        switch (proKey) {
            case "bizfilter": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bussiness")) break;
                String destJson = (String)this.getModel().getValue("bizfilterconfig_tag");
                ConditionHelper.openFilter((String)bussiness, (String)destJson, (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, proKey));
                break;
            }
            case "addcard": 
            case "addimg": 
            case "addlabel": {
                Map<String, Object> curOperData = this.getCurrentTask(-1);
                this.showTaskConfig(ADD_TASK, curOperData);
                break;
            }
            case "modifilap": {
                int index = this.getModel().getEntryCurrentRowIndex("taskentry");
                this.getPageCache().put(MODIFY_INDEX, String.valueOf(index));
                Map<String, Object> curOperData = this.getCurrentTask(index);
                this.showTaskConfig(MODIFY_TASK, curOperData);
                break;
            }
            case "deletetlap": {
                int focusRow = this.getModel().getEntryCurrentRowIndex("taskentry");
                if (!EmptyUtil.isEmpty((String)this.getPageCache().get(MODIFY_INDEX))) break;
                this.getModel().deleteEntryRow("taskentry", focusRow);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            if (MODIFY_TASK.equals(actionId)) {
                this.getPageCache().put(MODIFY_INDEX, "");
            }
            return;
        }
        switch (actionId) {
            case "bizfilter": {
                this.getModel().setValue("bizfilterconfig_tag", returnData);
                ConditionHelper.setFilterDescribe((Object)returnData, (IDataModel)this.getModel());
                break;
            }
            case "addtask": {
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
                int index = this.getModel().createNewEntryRow("taskentry");
                this.setTask(returnMap, index);
                break;
            }
            case "modifytask": {
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
                this.setTask(returnMap, (Integer)returnMap.get("index"));
                this.getPageCache().put(MODIFY_INDEX, "");
                break;
            }
            case "addorg": {
                this.addOrg(event);
                break;
            }
        }
    }

    private void showTaskConfig(String closeActionID, Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fcs_schedule_operconfig");
        if (customParam != null && !customParam.isEmpty()) {
            parameter.setCustomParam("initdata", customParam);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        this.getView().showForm(parameter);
    }

    private Map<String, Object> getCurrentTask(int rowIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("index", rowIndex);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String bussiness = (String)this.getModel().getValue("bussiness");
        map.put("bizapp", EmptyUtil.isNoEmpty((DynamicObject)bizApp) ? bizApp.getString("id") : null);
        map.put("bussiness", bussiness);
        map.put("issingle", this.getModel().getValue("issingle", rowIndex));
        map.put("eachbatchsize", this.getModel().getValue("eachbatchsize", rowIndex));
        if (rowIndex >= 0) {
            map.put("operatekey", this.getModel().getValue("operatekey", rowIndex));
            map.put("operatename", this.getModel().getValue("operatename", rowIndex));
            map.put("paramsetting", this.getModel().getValue("paramsetting", rowIndex));
            Object paramObj = this.getModel().getValue("paramcontent", rowIndex);
            if (!StringUtils.isBlank((Object)paramObj)) {
                map.put("param", JSONObject.parseObject((String)paramObj.toString(), Map.class));
            }
        }
        return map;
    }

    private QFilter getSelectOrgQFilter() {
        DynamicObjectCollection orgInfos = this.getModel().getEntryEntity("orgentry");
        ArrayList<Object> list = new ArrayList<Object>(orgInfos.size());
        for (DynamicObject orgInfo : orgInfos) {
            DynamicObject org = orgInfo.getDynamicObject("org");
            if (!EmptyUtil.isNoEmpty((DynamicObject)org)) continue;
            list.add(org.getPkValue());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        QFilter orgFilter = TmcOrgDataHelper.getAuthorizedBankOrgFilter((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
        return orgFilter.and(new QFilter("id", "not in", list));
    }

    private void addOrg(ClosedCallBackEvent event) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)event.getReturnData();
        ArrayList<Object> newOrgList = new ArrayList<Object>(rowDataCol.size());
        for (ListSelectedRow selectrow : rowDataCol) {
            if (!EmptyUtil.isNoEmpty((Object)selectrow.getPrimaryKeyValue())) continue;
            newOrgList.add(selectrow.getPrimaryKeyValue());
        }
        if (EmptyUtil.isNoEmpty(newOrgList)) {
            int[] rowIndexs = this.getModel().batchCreateNewEntryRow("orgentry", newOrgList.size());
            for (int i = 0; i < rowIndexs.length; ++i) {
                this.getModel().setValue("org", newOrgList.get(i), rowIndexs[i]);
            }
        }
    }

    private void initBizAppFilter(BeforeF7SelectEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String bizCloudProp = "bizcloud.number";
        if (TmcAppEnum.BEI.getValue().equals(appId) || "cbei".equals(appId)) {
            Map configs = TmcDataServiceHelper.loadFromCache((String)"fcs_schedulefilterconf", (String)"bizapp.number", (QFilter[])new QFilter[0]);
            Set appid = configs.values().stream().map(s -> s.getDynamicObject("bizapp").getString("number")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("number", "in", appid);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
        } else {
            QFilter tmcFilter = new QFilter(bizCloudProp, "=", (Object)"TMC");
            QFilter fiFilter = new QFilter(bizCloudProp, "=", (Object)"FI");
            fiFilter.and("number", "=", (Object)"cas");
            QFilter escFilter = new QFilter(bizCloudProp, "=", (Object)"ESC");
            escFilter.and("number", "=", (Object)"tr");
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(tmcFilter.or(fiFilter).or(escFilter));
        }
    }

    private void showTaskEntryParam() {
        DynamicObjectCollection taskEntrys = (DynamicObjectCollection)this.getModel().getValue("taskentry");
        CardEntry entry = (CardEntry)this.getControl("taskentry");
        for (int index = 0; index < taskEntrys.size(); ++index) {
            DynamicObject taskEntry = (DynamicObject)taskEntrys.get(index);
            String paramSetting = taskEntry.getString("paramsetting");
            entry.setChildVisible(EmptyUtil.isNoEmpty((String)paramSetting), index, new String[]{"labelap1", "paramsetting"});
        }
    }

    private void clearTaskEntry() {
        this.getModel().deleteEntryData("taskentry");
    }

    private void setTask(Map<String, Object> returnMap, int index) {
        String operName = (String)returnMap.get("operatename");
        this.getModel().setValue("taskname", (Object)operName, index);
        this.getModel().setValue("operatekey", returnMap.get("operatekey"), index);
        this.getModel().setValue("operatename", (Object)operName, index);
        this.getModel().setValue("issingle", returnMap.get("issingle"), index);
        this.getModel().setValue("eachbatchsize", returnMap.get("eachbatchsize"), index);
        Map operParam = (Map)returnMap.get("operParam");
        if (operParam != null && operParam.size() > 0) {
            Map operNameParam = (Map)returnMap.get("operParamName");
            this.getModel().setValue("paramsetting", (Object)this.getParamSetting(operNameParam), index);
            this.getModel().setValue("paramcontent", (Object)JSONObject.toJSONString(this.convertOperParam(operParam)), index);
        } else {
            CardEntry entry = (CardEntry)this.getControl("taskentry");
            entry.setChildVisible(false, index, new String[]{"labelap1", "paramsetting"});
        }
    }

    private Map<String, String> convertOperParam(Map<String, Object> operParam) {
        HashMap<String, String> map = new HashMap<String, String>(operParam.size());
        for (Map.Entry<String, Object> entry : operParam.entrySet()) {
            map.put(entry.getKey().split(SPLIT_STR)[0], entry.getValue().toString());
        }
        return map;
    }

    private String getParamSetting(Map<String, Object> operParam) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : operParam.entrySet()) {
            if (Objects.isNull(entry.getValue()) || StringUtils.isBlank((CharSequence)entry.getValue().toString())) continue;
            String key = entry.getKey();
            sb.append(key.split(SPLIT_STR)[1]);
            sb.append("=");
            sb.append(entry.getValue()).append(";");
        }
        return sb.length() > 50 ? sb.substring(0, 45) + "..." : sb.toString();
    }
}

