/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.helper.ScheduleBussinessOperateHelper;

public class ScheduleDetailLogList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ScheduleDetailLogList.class);
    private static final String EXECUTE_STATUS_FAIL = "fail";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String fieldName;
        super.filterContainerInit(args);
        String firstEntryFlag = this.getView().getPageCache().get("firstEntryFlag");
        if (Objects.isNull(firstEntryFlag)) {
            this.getView().getPageCache().put("firstEntryFlag", "false");
            Object schemaid = this.getView().getFormShowParameter().getCustomParams().get("schemaid");
            if (Objects.nonNull(schemaid)) {
                List commonFilterColumns = args.getCommonFilterColumns();
                for (FilterColumn column : commonFilterColumns) {
                    fieldName = column.getFieldName();
                    if (!fieldName.startsWith("schedule")) continue;
                    column.setDefaultValue(String.valueOf(schemaid));
                }
            }
        }
        if (TmcAppEnum.BEI.getValue().equals(this.getView().getFormShowParameter().getAppId())) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                fieldName = commonFilterColumn.getFieldName();
                if (!"schedule.name".equals(fieldName)) continue;
                Map schedules = TmcDataServiceHelper.loadFromCache((String)"fcs_schedule_proposal", (QFilter[])new QFilter[]{ScheduleBussinessOperateHelper.getQFilterByFilterConfig()});
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(20);
                for (DynamicObject schedule : schedules.values()) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(schedule.getString("name")));
                    item.setValue(schedule.getPkValue().toString());
                    comboItems.add(item);
                }
                commonFilterColumn.setComboItems(comboItems);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("schedule.id".equals(fieldName)) {
            args.getQfilters().clear();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getView().getPageCache().put("firstEntryFlag", "true");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        String fieldName = e.getHyperLinkClickEvent().getFieldName();
        if ("srcbillnumber".equals(fieldName) || "schedule_number".equals(fieldName) || "result".equals(fieldName)) {
            e.setCancel(true);
            Long id = (Long)((BillList)this.getControl("billlistap")).getFocusRowPkId();
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fcs_scheduledetail_log");
            if (dyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ScheduleDetailLogList_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openFormByField(e.getHyperLinkClickEvent().getFieldName(), dyn);
        }
    }

    private void openFormByField(String fieldId, DynamicObject dyn) {
        HashMap<String, Consumer<DynamicObject>> map = new HashMap<String, Consumer<DynamicObject>>(16);
        map.put("srcbillnumber", this::openSrcBill);
        map.put("schedule_number", this::openSchema);
        map.put("result", this::showTaskErrorLog);
        ((Consumer)map.get(fieldId)).accept(dyn);
    }

    private void openSrcBill(DynamicObject dyn) {
        String billno = dyn.getString("srcbillnumber");
        String bussiness = dyn.getString("bussiness");
        Set fieldsSet = EntityMetadataCache.getDataEntityType((String)bussiness).getAllFields().keySet();
        String number = "";
        if (fieldsSet.contains("billno")) {
            number = "billno";
        } else if (fieldsSet.contains("number")) {
            number = "number";
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6765\u6e90\u5355\u636e\u7f16\u7801\u5b57\u6bb5\u3002", (String)"ScheduleDetailLogList_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter(number, "=", (Object)billno);
        filter.and(new QFilter("id", "=", dyn.get("srcbillid")));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)bussiness, (String)("id," + number), (QFilter[])filter.toArray());
        if (objs == null || objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6765\u6e90\u5355\u636e\u7f16\u7801\u5b57\u6bb5\u3002", (String)"ScheduleDetailLogList_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFormByPKId(objs[0].get("id"), bussiness);
    }

    private void openSchema(DynamicObject dyn) {
        DynamicObject schedule = dyn.getDynamicObject("schedule");
        String entity = ScheduleTaskTypeEnum.isOperation((String)schedule.getString("tasktype")) ? "fcs_schedule_bussoper" : "fcs_schedule_task";
        this.openFormByPKId(schedule.getLong("id"), entity);
    }

    private void openFormByPKId(Object pkId, String bussiness) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(bussiness);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showTaskErrorLog(DynamicObject detail) {
        Object task = detail.get("taskid");
        if (EmptyUtil.isEmpty((Object)task)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.taskid", "=", (Object)task.toString())};
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fcs_schedule_log", (String)"entryentity.schejobid schejobid,entryentity.executestatus executestatus", (QFilter[])filters);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)list)) {
            DynamicObject log = (DynamicObject)list.get(0);
            if (!EXECUTE_STATUS_FAIL.equals(log.get("executestatus"))) {
                logger.info("execute status is {}", log.get("executestatus"));
                return;
            }
            String scheJobId = log.getString("schejobid");
            if (EmptyUtil.isBlank((CharSequence)scheJobId)) {
                return;
            }
            DynamicObject taskDefine = TmcDataServiceHelper.loadSingleFromCache((Object)scheJobId, (String)"sch_taskdefine");
            if (EmptyUtil.isEmpty((DynamicObject)taskDefine)) {
                logger.info("not fund taskDefine class");
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("sch_errorjob_details");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taskId", (Object)task.toString());
            parameter.setCustomParam("jobname", (Object)taskDefine.getString("name"));
            parameter.setCustomParam("planname", (Object)detail.getString("schedule.name"));
            parameter.setCustomParam("jobnumber", (Object)taskDefine.getString("number"));
            this.getView().showForm(parameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object taskId;
        super.setFilter(e);
        String firstEntryFlag = this.getView().getPageCache().get("firstEntryFlag");
        if (TmcAppEnum.BEI.getValue().equals(this.getView().getFormShowParameter().getAppId())) {
            Map schedules = TmcDataServiceHelper.loadFromCache((String)"fcs_schedule_proposal", (QFilter[])new QFilter[]{ScheduleBussinessOperateHelper.getQFilterByFilterConfig()});
            e.getQFilters().add(new QFilter("schedule", "in", schedules.keySet()));
        }
        if (Boolean.TRUE.toString().equals(firstEntryFlag)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object schemasumlogid = customParams.get("schemasumlogid");
        if (null != schemasumlogid) {
            DynamicObjectCollection operLogDyns = QueryServiceHelper.query((String)"fcs_scheduleopersum_log", (String)"id", (QFilter[])new QFilter[]{new QFilter("schemasumlogid", "=", schemasumlogid)}, null);
            Set operLogIds = operLogDyns.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            QFilter filter = new QFilter("opersumlogid", "in", operLogIds);
            e.getQFilters().add(filter);
        }
        if (null != (taskId = customParams.get("taskid"))) {
            QFilter filter = new QFilter("taskid", "in", taskId);
            e.getQFilters().add(filter);
        }
    }
}

