/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.helper.ScheduleBussinessOperateHelper;

public class ScheduleProposalEdit
extends AbstractBasePlugIn {
    private static final String AFTER_CONFIRM = "afterConfirm";
    private static final Log logger = LogFactory.getLog(ScheduleProposalEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("inforeceiver", (Object)RequestContext.get().getCurrUserId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showPlanSettingForm();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            String taskType;
            if (!op.getOption().getVariables().containsKey(AFTER_CONFIRM) && "operation".equals(taskType = (String)this.getModel().getValue("tasktype"))) {
                Set<String> entityNumbers;
                String entityNumner = (String)this.getModel().getValue("bussiness");
                String number = (String)this.getModel().getValue("number");
                DynamicObjectCollection taskEntry = (DynamicObjectCollection)this.getModel().getValue("taskentry");
                Field[] fields = new Field[]{new Field("tmc_entitynumber", (DataType)DataType.StringType), new Field("tmc_opkey", (DataType)DataType.StringType), new Field("tmc_number", (DataType)DataType.StringType)};
                RowMeta rowMeta = new RowMeta(fields);
                DataSetBuilder dsBuilder = Algo.create((String)"ScheduleProposalEdit_save").createDataSetBuilder(rowMeta);
                HashSet<String> opKeys = new HashSet<String>(taskEntry.size());
                for (DynamicObject row : taskEntry) {
                    String opKey = row.getString("operatekey");
                    opKeys.add(opKey);
                    Object[] data = new Object[]{entityNumner, opKey, number};
                    dsBuilder.append(data);
                }
                DataSet tmcScheduleDataSet = dsBuilder.build();
                Map result = ScheduleBussinessOperateHelper.checkExistIntellExecSchema((DataSet)tmcScheduleDataSet, entityNumbers = Collections.singleton(entityNumner), opKeys);
                Set intellExecSchemaNumber = (Set)result.get(number);
                if (EmptyUtil.isNoEmpty((Object)intellExecSchemaNumber)) {
                    String sb = ScheduleBussinessOperateHelper.getWarningMessage((Set)intellExecSchemaNumber) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u7ee7\u7eed\u4fdd\u5b58\u5417\uff1f", (String)"ScheduleProposalEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(sb, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_back_save", (IFormPlugin)this));
                    args.setCancel(true);
                    return;
                }
            }
            if (!this.validatePlanSave()) {
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("confirm_back_save".equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CONFIRM, "1");
            this.getView().invokeOperation("save", option);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey())) {
            IDataModel model = this.getModel();
            DynamicObject plan = (DynamicObject)model.getValue("scheplan");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"status", (Object)BillStatusEnum.SAVE.getValue());
            if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.ADDNEW.getValue() && !args.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((DynamicObject)plan)) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"sch_schedule"), (Object[])new Object[]{plan.getPkValue()});
                model.setValue("scheplan", null);
            }
            this.showPlanSettingForm();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        BillShowParameter showParameter;
        super.preOpenForm(e);
        Object source = e.getSource();
        if (source instanceof BillShowParameter && EmptyUtil.isNoEmpty((Object)(showParameter = (BillShowParameter)source).getPkId())) {
            DynamicObject schedule = TmcDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(showParameter.getPkId().toString()), (String)"fcs_schedule_proposal");
            String taskType = schedule.getString("tasktype");
            if (ScheduleTaskTypeEnum.isOperation((String)taskType)) {
                showParameter.setFormId("fcs_schedule_bussoper");
            } else if (ScheduleTaskTypeEnum.isJob((String)taskType)) {
                showParameter.setFormId("fcs_schedule_task");
            }
        }
    }

    private void changePlanJobParam() {
        String oldApp;
        String planPageId = this.getPageCache().get("planPageId");
        if (EmptyUtil.isBlank((CharSequence)planPageId)) {
            return;
        }
        IFormView planView = SessionManager.getCurrent().getView(planPageId);
        FormShowParameter parameter = planView.getFormShowParameter();
        IDataModel model = this.getModel();
        DynamicObject executor = (DynamicObject)model.getValue("executor");
        if (executor != null) {
            long executorId = executor.getLong("id");
            parameter.setCustomParam("executor", (Object)executorId);
        }
        String appId = this.getAppId();
        parameter.setCustomParam("taskappnumber", (Object)appId);
        parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(appId));
        DynamicObject schePlan = (DynamicObject)this.getModel().getValue("scheplan");
        if (EmptyUtil.isEmpty((DynamicObject)schePlan)) {
            return;
        }
        DynamicObject schJob = TmcDataServiceHelper.loadSingle((Object)schePlan.get("job.id"), (String)"sch_job");
        boolean isJobChange = false;
        if (executor != null) {
            long executorId = executor.getLong("id");
            if (schJob.getLong("runbyuser.id") != executorId) {
                isJobChange = true;
                schJob.set("runbyuser", (Object)executorId);
            }
        }
        if (!appId.equals(oldApp = schJob.getString("taskclassname.appid"))) {
            isJobChange = true;
            schJob.set("taskclassname", (Object)this.getExecClass(appId));
        }
        if (isJobChange) {
            logger.info("job info change");
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{schJob});
        }
    }

    private boolean validatePlanSave() {
        String planPageId = this.getPageCache().get("planPageId");
        boolean success = false;
        if (EmptyUtil.isBlank((CharSequence)planPageId)) {
            return success;
        }
        IFormView planView = SessionManager.getCurrent().getView(planPageId);
        IDataModel planModel = planView.getModel();
        DataEntityPropertyCollection props = planModel.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : props) {
            boolean isMustInput;
            String fieldName = prop.getName();
            if ("plan".equals(fieldName)) continue;
            Object value = planModel.getValue(fieldName);
            if (prop instanceof BigIntProp && value == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570[%s]\u4e3a\u5fc5\u586b\u53c2\u6570\uff0c\u8bf7\u586b\u5199\u3002", (String)"ScheduleOperConfigPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), prop.getDisplayName()));
            }
            if (!(prop instanceof FieldProp) || !(isMustInput = ((FieldProp)prop).isMustInput()) || !EmptyUtil.isEmpty((Object)value)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570[%s]\u4e3a\u5fc5\u586b\u53c2\u6570\uff0c\u8bf7\u586b\u5199\u3002", (String)"ScheduleOperConfigPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), prop.getDisplayName()));
        }
        Date starttime = (Date)planModel.getValue("starttime");
        Date endtime = (Date)planModel.getValue("endtime");
        if (endtime.before(starttime)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ScheduleOperConfigPlugin_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        }
        this.changePlanJobParam();
        OperationResult operationResult = planView.invokeOperation("save");
        success = operationResult.isSuccess();
        if (success) {
            DynamicObject plan = planView.getModel().getDataEntity();
            this.getModel().setValue("scheplan", plan.getPkValue());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25\u3002", (String)"ScheduleProposalEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        }
        return success;
    }

    private void showPlanSettingForm() {
        long id = this.getOrSetBillId();
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("planpanel");
        parameter.setFormId("fcs_schedule_plan");
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        IDataModel model = this.getModel();
        DynamicObject plan = (DynamicObject)model.getValue("scheplan");
        if (EmptyUtil.isEmpty((DynamicObject)plan)) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("intellSchemaidList", Collections.singleton(Collections.singletonMap("Id", id)));
            params.put("type", "0");
            parameter.setCustomParam("paramjsonstr", (Object)SerializationUtils.toJsonString(params));
            parameter.setCustomParam("taskclassname", (Object)"kd.bos.ext.tmc.task.TmcScheduleTask");
            parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleProposalEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("schedulename", (Object)ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleProposalEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("tasknumber", (Object)("fcs_autocreate" + System.currentTimeMillis()));
            DynamicObject executor = (DynamicObject)model.getValue("executor");
            if (executor != null) {
                parameter.setCustomParam("executor", executor.get("id"));
            }
        } else {
            parameter.setPkId(plan.getPkValue());
        }
        String appId = this.getAppId();
        parameter.setCustomParam("taskappnumber", (Object)appId);
        parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(appId));
        parameter.setHasRight(true);
        parameter.setCustomParam("frombiz", (Object)"true");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private long getOrSetBillId() {
        IBillModel billmodel = (IBillModel)this.getModel();
        long id = (Long)billmodel.getValue("id");
        if (StringUtils.isBlank((Object)id) || id == 0L) {
            String tableName = billmodel.getDataEntityType().getAlias();
            long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
            id = ids[0];
            billmodel.getDataEntity().set("id", (Object)id);
        }
        return id;
    }

    private String getAppId() {
        String appId = TmcAppEnum.FCS.getValue();
        IBillModel billmodel = (IBillModel)this.getModel();
        DynamicObject entity = billmodel.getDataEntity();
        String taskType = entity.getString("tasktype");
        if (ScheduleTaskTypeEnum.isOperation((String)taskType) && EmptyUtil.isNotBlank((CharSequence)entity.getString("bizapp.number"))) {
            appId = entity.getString("bizapp.number");
        } else if (ScheduleTaskTypeEnum.isJob((String)taskType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)billmodel.getEntryEntity("taskentry"))) {
            appId = ((DynamicObject)billmodel.getEntryEntity("taskentry").get(0)).getString("schejob.appid");
        }
        return appId;
    }

    private DynamicObject getExecClass(String appId) {
        QFilter filter = new QFilter("classname", "=", (Object)"kd.bos.ext.tmc.task.TmcScheduleTask");
        filter.and("appid", "=", (Object)appId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id", (QFilter[])filter.toArray(), null);
        if (null != load && load.length > 0) {
            return load[0];
        }
        DynamicObject taskDyn = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
        taskDyn.set("name", (Object)("TmcTask-" + appId));
        taskDyn.set("number", (Object)("TmcTask-" + appId));
        taskDyn.set("classname", (Object)"kd.bos.ext.tmc.task.TmcScheduleTask");
        taskDyn.set("appid", (Object)appId);
        DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDyn});
        return save[0];
    }

    private String getExecClassName(String appId) {
        return this.getExecClass(appId).getString("id");
    }
}

