/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fcs.common.dao.FormDesignDao;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.helper.ScheduleBussinessOperateHelper;

public class ScheduleProposalList
extends AbstractTmcListPlugin {
    private static final String AFTER_CONFIRM = "afterConfirm";
    private static final String CACHE_NEWFORM = "newForm";
    private static final String BTN_STOPEXECUTE = "stopexecute";

    public void setFilter(SetFilterEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (TmcAppEnum.BEI.getValue().equals(appId) || "cbei".equals(appId)) {
            e.getQFilters().add(ScheduleBussinessOperateHelper.getQFilterByFilterConfig());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IPageCache pageCache = this.getPageCache();
        if ("operate".equals(evt.getItemKey())) {
            pageCache.put(CACHE_NEWFORM, "fcs_schedule_bussoper");
        } else if ("task".equals(evt.getItemKey())) {
            pageCache.put(CACHE_NEWFORM, "fcs_schedule_task");
        } else if (BTN_STOPEXECUTE.equals(evt.getItemKey())) {
            this.checkStopSchedule(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        if ("enable".equals(op.getOperateKey()) && !op.getOption().getVariables().containsKey(AFTER_CONFIRM)) {
            Object[] ids = args.getListSelectedData().getPrimaryKeyValues();
            DataSet tmcScheduleDataSet = QueryServiceHelper.queryDataSet((String)"ScheduleProposalList_fcs_schedule_proposal", (String)"fcs_schedule_proposal", (String)"id,number tmc_number,taskentry.operatekey tmc_opkey,bussiness tmc_entitynumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
            HashSet<String> opKeys = new HashSet<String>(16);
            HashSet<String> entityNumbers = new HashSet<String>(16);
            HashSet<String> numbers = new HashSet<String>(16);
            HashMap<String, Object> numbers_IDs = new HashMap<String, Object>(16);
            for (Row row : tmcScheduleDataSet.copy()) {
                numbers.add(row.getString("tmc_number"));
                opKeys.add(row.getString("tmc_opkey"));
                entityNumbers.add(row.getString("tmc_entitynumber"));
                numbers_IDs.put(row.getString("tmc_number"), row.get("id"));
            }
            Map result = ScheduleBussinessOperateHelper.checkExistIntellExecSchema((DataSet)tmcScheduleDataSet, entityNumbers, opKeys);
            if (result.size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5f85\u786e\u8ba4%2$s\u6761\u3002\u786e\u5b9a\u8981\u7ee7\u7eed\u542f\u7528\u5417\uff1f", (String)"ScheduleProposalList_3", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), numbers.size(), result.size()));
                numbers.removeAll(result.keySet());
                HashSet enableScheduleIds = new HashSet(numbers.size());
                for (Map.Entry entry : result.entrySet()) {
                    sb.append("\r\n");
                    sb.append((String)entry.getKey()).append(" : ");
                    sb.append(ScheduleBussinessOperateHelper.getWarningMessage((Set)((Set)entry.getValue())));
                }
                numbers.forEach(s -> enableScheduleIds.add(numbers_IDs.get(s)));
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_back_enable", (IFormPlugin)this));
                args.setCancel(true);
                this.getView().getPageCache().put("enableScheduleIds", SerializationUtils.toJsonString(enableScheduleIds));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("confirm_back_enable".equals(callBackId)) {
            OperateOption option = OperateOption.create();
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                option.setVariableValue(AFTER_CONFIRM, "1");
                this.getView().invokeOperation("enable", option);
            } else {
                Set enableScheduleIds = (Set)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("enableScheduleIds"), Set.class);
                if (EmptyUtil.isNoEmpty((Object)enableScheduleIds)) {
                    TmcOperateServiceHelper.execOperate((String)"enable", (String)"fcs_schedule_proposal", (Object[])enableScheduleIds.toArray(new Object[0]), (OperateOption)option);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void checkStopSchedule(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        Set selSet = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (selSet.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u4e2d\u6b62\u3002", (String)"ScheduleProposalList_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            QFilter[] filters;
            DynamicObjectCollection tasks;
            Object scheduleId = selSet.toArray()[0];
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"checkStopSchedule", (String)"fcs_schedule_log", (QFilter[])new QFilter("schedule", "=", scheduleId).toArray(), null, (int)1);
            if (EmptyUtil.isNoEmpty((Object)ids) && EmptyUtil.isEmpty((DynamicObjectCollection)(tasks = QueryServiceHelper.query((String)"fcs_schedule_log", (String)"entryentity.taskname", (QFilter[])(filters = new QFilter[]{new QFilter("schedule", "=", scheduleId), new QFilter("entryentity.executestatus", "=", (Object)"processing")}))))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u6267\u884c\u5b8c\u6210\u3002", (String)"ScheduleProposalList_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String newForm = this.getPageCache().get(CACHE_NEWFORM);
        if (EmptyUtil.isNotBlank((CharSequence)newForm)) {
            this.getPageCache().remove(CACHE_NEWFORM);
            e.getParameter().setFormId(newForm);
        } else {
            DynamicObject object = TmcDataServiceHelper.loadSingleFromCache((Object)e.getParameter().getPkId(), (String)"fcs_schedule_proposal");
            String taskType = object.getString("tasktype");
            if (ScheduleTaskTypeEnum.isOperation((String)taskType)) {
                e.getParameter().setFormId("fcs_schedule_bussoper");
            } else if (ScheduleTaskTypeEnum.isJob((String)taskType)) {
                e.getParameter().setFormId("fcs_schedule_task");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_STOPEXECUTE.equals(itemKey)) {
            this.setTaskStopFlag(this.getSelectedId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e2d\u6b62\u6210\u529f\u3002", (String)"ScheduleProposalList_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject row = e.getRowData();
        Object source = e.getSource();
        if (source instanceof ComboColumnDesc && ((ComboColumnDesc)source).getKey().equals("bussiness")) {
            String bussiness = row.getString("bussiness");
            String bussName = FormDesignDao.getDesignFormName((String)bussiness);
            e.setFormatValue((Object)bussName);
        }
    }

    private void setTaskStopFlag(Long scheId) {
        IAppCache cache = AppCache.get((String)TmcAppEnum.FCS.getValue());
        cache.put("fcs-scheduleproposal-" + scheId + "stop-flag", (Object)"stop");
    }
}

