/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.helper.ScheduleTaskHelper;

public class ScheduleTaskEdit
extends AbstractBasePlugIn {
    private static final String ADD_TASK = "addtask";
    private static final String MODIFY_TASK = "modifytask";
    private static final String SPLIT_STR = ":";
    private static final String ENTRY_INDEX = "entryindex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("status"))) {
            this.addClickListeners(new String[]{"addcard", "addimg", "addlabel", "deletetlap", "modifilap"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("tasktype", (Object)ScheduleTaskTypeEnum.JOB.getValue());
    }

    public void click(EventObject evt) {
        String proKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (proKey = source.getKey()) {
            case "addcard": 
            case "addimg": 
            case "addlabel": {
                Map<String, Object> curOperData = this.getCurrentTask(-1);
                this.showTaskConfig(ADD_TASK, curOperData);
                break;
            }
            case "modifilap": {
                int index = this.getModel().getEntryCurrentRowIndex("taskentry");
                Map<String, Object> curOperData = this.getCurrentTask(index);
                this.showTaskConfig(MODIFY_TASK, curOperData);
                break;
            }
            case "deletetlap": {
                int focusRow = this.getModel().getEntryCurrentRowIndex("taskentry");
                this.getModel().deleteEntryRow("taskentry", focusRow);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId) {
            case "addtask": {
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
                int newEntryRow = this.getModel().createNewEntryRow("taskentry");
                this.setTask(returnMap, newEntryRow);
                break;
            }
            case "modifytask": {
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
                this.setTask(returnMap, (Integer)returnMap.get(ENTRY_INDEX));
                break;
            }
        }
    }

    private void showTaskConfig(String callBackId, Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fcs_schedule_taskconfig");
        if (customParam != null && !customParam.isEmpty()) {
            parameter.setCustomParam("initdata", customParam);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        this.getView().showForm(parameter);
    }

    private Map<String, Object> getCurrentTask(int rowIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(ENTRY_INDEX, rowIndex);
        IDataModel model = this.getModel();
        if (rowIndex >= 0) {
            DynamicObject scheJob = (DynamicObject)model.getValue("schejob", rowIndex);
            map.put("schejob", scheJob.getPkValue());
            Object paramObj = model.getValue("paramcontent", rowIndex);
            if (!StringUtils.isBlank((Object)paramObj)) {
                map.put("param", JSONObject.parseObject((String)paramObj.toString(), Map.class));
            }
        }
        return map;
    }

    private void setTask(Map<String, Object> returnMap, int index) {
        IDataModel model = this.getModel();
        Object schJob = returnMap.get("schejob");
        if (EmptyUtil.isEmpty((Object)schJob)) {
            return;
        }
        DynamicObject schTask = TmcDataServiceHelper.loadSingleFromCache((Object)schJob, (String)"sch_taskdefine");
        model.setValue("schejob", schTask.getPkValue(), index);
        String appid = schTask.getString("appid");
        Map<String, String> appMap = ScheduleTaskHelper.getAppList().stream().collect(Collectors.toMap(t -> (String)t.item1, t -> (String)t.item2, (p, q) -> p));
        model.setValue("scheappname", (Object)appMap.get(appid), index);
        String scheName = schTask.getString("name");
        scheName = StringUtils.isNotBlank((CharSequence)scheName) ? scheName : schTask.getString("classname");
        model.setValue("taskname", (Object)scheName, index);
        Object paramObj = returnMap.get("operParam");
        if (paramObj != null) {
            Map operParam = (Map)paramObj;
            Map operNameParam = (Map)returnMap.get("operParamName");
            model.setValue("paramsetting", (Object)this.getParamSetting(operNameParam), index);
            model.setValue("paramcontent", (Object)JSONObject.toJSONString(this.convertOperParam(operParam)), index);
        } else {
            model.setValue("paramsetting", (Object)"", index);
            model.setValue("paramcontent", (Object)"", index);
        }
    }

    private Map<String, Object> convertOperParam(Map<String, Object> operParam) {
        HashMap<String, Object> map = new HashMap<String, Object>(operParam.size());
        for (Map.Entry<String, Object> entry : operParam.entrySet()) {
            map.put(entry.getKey().split(SPLIT_STR)[0], entry.getValue());
        }
        return map;
    }

    private String getParamSetting(Map<String, Object> operParam) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : operParam.entrySet()) {
            if (Objects.isNull(entry.getValue()) || StringUtils.isBlank((CharSequence)entry.getValue().toString())) continue;
            String key = entry.getKey();
            sb.append(key.split(SPLIT_STR)[1]);
            sb.append("=");
            sb.append(entry.getValue()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.length() > 50 ? sb.substring(0, 45) + "..." : sb.toString();
    }
}

