/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.ScheduleBussinessOperateHelper;
import kd.tmc.fcs.common.helper.ScheduleTaskHelper;
import kd.tmc.fcs.common.model.DynamicParamBean;
import kd.tmc.fcs.common.model.ParamEntryBean;

public class ScheduleTaskParamEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_TASK_PARAM_SET = "taskparamset";
    private static final String PARAM_PAGEID = "paramPageId";
    private static final String ENTRY_INDEX = "entryindex";
    private static final String SCHEAPPID = "scheappid";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map initData = (Map)formShowParameter.getCustomParams().get("initdata");
        if (EmptyUtil.isNoEmpty((Object)initData)) {
            IDataModel model = this.getModel();
            if (null != initData.get("schejob")) {
                DynamicObject schTask = TmcDataServiceHelper.loadSingleFromCache(initData.get("schejob"), (String)"sch_taskdefine");
                model.setValue("schejob", (Object)schTask);
                model.setValue(SCHEAPPID, (Object)schTask.getString("appid"));
                model.setValue(ENTRY_INDEX, initData.get(ENTRY_INDEX));
                this.showOperParam();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(SCHEAPPID);
        comboEdit.setComboItems(ScheduleTaskHelper.getAppComboItems());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl("schejob");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("schejob".equals(name)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            HashSet<String> app = new HashSet<String>(16);
            if (TmcAppEnum.BEI.getValue().equals(appId) || "cbei".equals(appId)) {
                app.add(TmcAppEnum.BEI.getValue());
            } else {
                app.addAll(ScheduleTaskHelper.getAppList().stream().map(t -> (String)t.item1).collect(Collectors.toSet()));
            }
            QFilter qFilter = new QFilter("appid", "in", app).and(new QFilter("classname", "not in", Arrays.asList("kd.fi.iep.task.IntellExceTask", "kd.bos.ext.tmc.task.TmcScheduleTask", "kd.tmc.fpm.business.task.ReportImportDataTask", "kd.bos.service.earlywarn.EarlyWarnScheduleTask")));
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        if ("schejob".equals(name)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (EmptyUtil.isEmpty((DynamicObject)newValue)) {
                model.setValue(SCHEAPPID, null);
            } else {
                model.setValue(SCHEAPPID, (Object)newValue.getString("appid"));
                this.showOperParam();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && OP_TASK_PARAM_SET.equals(((AbstractOperate)source).getOperateKey())) {
            String pageId = this.getPageCache().get(PARAM_PAGEID);
            if (EmptyUtil.isBlank((CharSequence)pageId) || EmptyUtil.isEmpty((Object)this.getModel().getValue("schejob"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScheduleTaskParamEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView paramView = SessionManager.getCurrent().getView(pageId);
            DataEntityPropertyCollection props = paramView.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty prop : props) {
                boolean isMustInput;
                String fieldName = prop.getName();
                Object value = paramView.getModel().getValue(fieldName);
                if (!(prop instanceof BigIntProp ? (isMustInput = ((BigIntProp)prop).isMustInput()) && value == null : prop instanceof FieldProp && (isMustInput = ((FieldProp)prop).isMustInput()) && EmptyUtil.isEmpty((Object)value))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570[%s]\u4e3a\u5fc5\u586b\u53c2\u6570\uff0c\u8bf7\u586b\u5199\u3002", (String)"ScheduleOperConfigPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), prop.getDisplayName()));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_TASK_PARAM_SET.equals(operateKey)) {
            Map<String, Object> paramMap = this.getTaskParamMap();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(paramMap));
            this.getView().close();
        }
    }

    private Map<String, Object> getTaskParamMap() {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        IDataModel model = this.getModel();
        DynamicObject job = (DynamicObject)model.getValue("schejob");
        resMap.put("schejob", job.getPkValue());
        resMap.put(ENTRY_INDEX, model.getValue(ENTRY_INDEX));
        this.storeParamValue(resMap);
        return resMap;
    }

    private void storeParamValue(Map<String, Object> data) {
        String pageId = this.getPageCache().get(PARAM_PAGEID);
        IFormView paramView = SessionManager.getCurrent().getView(pageId);
        IDataModel model = paramView.getModel();
        DataEntityPropertyCollection props = model.getDataEntityType().getProperties();
        Iterator its = props.iterator();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(props.size() * 2);
        HashMap<String, Object> paramNameMap = new HashMap<String, Object>(props.size() * 2);
        Map paramComBoxMap = null;
        while (its.hasNext()) {
            Object value;
            IDataEntityProperty prop = (IDataEntityProperty)its.next();
            String fieldName = prop.getName();
            Object nameVal = value = model.getValue(fieldName);
            if (prop instanceof ComboProp) {
                String[] split;
                String realKey;
                JSONObject json;
                if (null == paramComBoxMap) {
                    String paramBeanStr = this.getPageCache().get("operParam");
                    DynamicParamBean bean = (DynamicParamBean)JSONObject.parseObject((String)paramBeanStr, DynamicParamBean.class);
                    paramComBoxMap = ScheduleBussinessOperateHelper.getParamComBoxMap((DynamicParamBean)bean);
                }
                if (null != (json = (JSONObject)paramComBoxMap.get(realKey = (split = StringUtils.split((String)fieldName, (String)"-"))[split.length - 1]))) {
                    Object val = json.get(value);
                    nameVal = null != val ? val : value;
                }
            }
            String fieldKey = fieldName + ":" + prop.getDisplayName().getLocaleValue();
            paramMap.put(fieldKey, value);
            paramNameMap.put(fieldKey, nameVal);
        }
        data.put("operParam", paramMap);
        data.put("operParamName", paramNameMap);
    }

    private void showOperParam() {
        DynamicObject scheJob = (DynamicObject)this.getModel().getValue("schejob");
        if (EmptyUtil.isEmpty((DynamicObject)scheJob)) {
            return;
        }
        List params = ScheduleBussinessOperateHelper.getParamList((QFilter[])new QFilter("classname", "=", scheJob.getPkValue()).toArray());
        FormShowParameter para = new FormShowParameter();
        if (params.size() > 0) {
            Object paramObj;
            DynamicParamBean paramBean = (DynamicParamBean)params.get(0);
            Map initData = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
            Map paramVal = null;
            if (initData != null && (paramObj = initData.get("param")) != null) {
                paramVal = (Map)initData.get("param");
            }
            DynamicParamBean model = (DynamicParamBean)params.get(0);
            if (paramVal != null && paramVal.size() > 0) {
                String key = model.getUniqueKey();
                List allParams = paramBean.getParams();
                for (ParamEntryBean each : allParams) {
                    Object val = paramVal.get(key + each.getNumber());
                    if (val == null) continue;
                    each.setParamval(val.toString());
                }
            }
            para.setFormId("fcs_schedule_paramop");
            para.getOpenStyle().setTargetKey("flexpanelparam");
            para.getOpenStyle().setShowType(ShowType.InContainer);
            para.setCustomParam("operParam", (Object)SerializationUtils.toJsonString((Object)paramBean));
            this.getView().showForm(para);
        } else {
            para.setFormId("fcs_schedule_paramop");
            para.getOpenStyle().setTargetKey("flexpanelparam");
            para.getOpenStyle().setShowType(ShowType.InContainer);
            para.setCustomParam("operParam", (Object)SerializationUtils.toJsonString((Object)new DynamicParamBean()));
            this.getView().showForm(para);
        }
        this.getPageCache().put("operParam", (String)para.getCustomParam("operParam"));
        this.getPageCache().put(PARAM_PAGEID, para.getPageId());
    }
}

