/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ScheduleTipsList
extends AbstractListPlugin {
    private static final String TIPS = "tips";
    private static final String NUM = "num";
    private static final String VIEW = "view";
    private static final String HIDE = "hide";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NUM, VIEW, HIDE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Set<Object> IntellExecSchemaIds = this.getIntellExecSchemas();
        int IntellExecSchemaCounts = IntellExecSchemaIds.size();
        this.getView().setVisible(Boolean.valueOf(IntellExecSchemaCounts > 0), new String[]{TIPS});
        Label numLabel = (Label)this.getView().getControl(NUM);
        numLabel.setText(String.valueOf(IntellExecSchemaCounts));
    }

    private Set<Object> getIntellExecSchemas() {
        QFilter qFilter;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (TmcAppEnum.BEI.getValue().equals(appId)) {
            Map configs = TmcDataServiceHelper.loadFromCache((String)"fcs_schedulefilterconf", (String)"entitynumber,opkey", (QFilter[])new QFilter[0]);
            qFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            for (Map.Entry entry : configs.entrySet()) {
                DynamicObject config = (DynamicObject)entry.getValue();
                List entitynumbers = Arrays.stream(config.getString("entitynumber").split(",")).collect(Collectors.toList());
                QFilter qFilter1 = new QFilter("operationentry.bussiness", "in", entitynumbers);
                String opkey = config.getString("opkey");
                if (EmptyUtil.isNoEmpty((String)opkey)) {
                    qFilter1.and("operationentry.oper", "in", Arrays.stream(opkey.split(",")).collect(Collectors.toList()));
                }
                qFilter.or(qFilter1);
            }
        } else {
            List appIds = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)TmcAppEnum.TMC.getId())}).stream().map(s -> s.getString("id")).collect(Collectors.toList());
            appIds.add(TmcAppEnum.CAS.getId());
            appIds.add(TmcAppEnum.TR.getId());
            qFilter = new QFilter("operationentry.appid", "in", appIds);
        }
        DynamicObjectCollection schemas = QueryServiceHelper.query((String)"gl_intellexecschema", (String)"id,sheduleplanid", (QFilter[])new QFilter[]{qFilter, new QFilter("enable", "=", (Object)"1")});
        Set sheduleplanIds = schemas.stream().map(s -> s.getString("sheduleplanid")).collect(Collectors.toSet());
        QFilter qFilter1 = new QFilter("repeatmode", "!=", (Object)"n").and("id", "in", sheduleplanIds).and("endtime", ">=", (Object)new Date());
        List scheduleIds = QueryServiceHelper.query((String)"sch_schedule", (String)"id", (QFilter[])qFilter1.toArray()).stream().map(s -> s.getString("id")).collect(Collectors.toList());
        return schemas.stream().filter(s -> scheduleIds.contains(s.getString("sheduleplanid"))).map(s -> s.get("id")).collect(Collectors.toSet());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "num": 
            case "view": {
                Set<Object> IntellExecSchemaIds = this.getIntellExecSchemas();
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("gl_intellexecschema");
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_intellexecschema");
                listShowParameter.setCaption(type.getDisplayName().getLocaleValue());
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", IntellExecSchemaIds));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "hide": {
                this.getView().setVisible(Boolean.FALSE, new String[]{TIPS});
                break;
            }
        }
    }
}

