/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;
import kd.tmc.fcs.common.enums.ScheduleTodayStatusEnum;
import kd.tmc.fcs.common.helper.OpenBillHelper;
import kd.tmc.fcs.formplugin.schedule.ScheExecItem;

public class ScheduleTodayEdit
extends AbstractFormPlugin
implements CellClickListener {
    private Map<Integer, List<ScheExecItem>> panelMap;
    private static final String FINISH_IMG_KEY = "/icons/pc/state/completed_13_13.png";
    private static final String SELECT_IMG_KEY = "/icons/pc/state/selected_13_13.png";
    private static final String NO_START_IMG_KEY = "/icons/pc/state/not_passing_13_13.png";
    private static final List<BetweenHour> CARD_SUFFIX_ARRAY = new LinkedList<BetweenHour>();
    private static final int CARD_MINUS = 240;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (BetweenHour item : CARD_SUFFIX_ARRAY) {
            EntryGrid gridControl = (EntryGrid)this.getControl("explan" + item.column);
            gridControl.addCellClickListener((CellClickListener)this);
            this.addClickListeners(new String[]{"viewlog" + item.column});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateTimeLabel();
        this.drawScheduleItem();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.drawEntryView();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && (key = ((Control)source).getKey()).startsWith("viewlog")) {
            String suffix = key.substring("viewlog".length());
            int index = this.getModel().getEntryCurrentRowIndex("explan" + suffix);
            this.showScheduleLogList(suffix, index);
        }
    }

    private void showScheduleLogList(String suffix, int row) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("explan" + suffix);
        String logId = ((DynamicObject)entryEntity.get(row)).getString("taskid" + suffix);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fcs_schedule_log");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setCustomParam("sumlogid", (Object)logId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void updateTimeLabel() {
        int i;
        int indexHour = this.checkWhereTime();
        for (i = 0; i < indexHour; ++i) {
            String imgKey = "timeimg" + i;
            this.updateImgControl(FINISH_IMG_KEY, imgKey);
        }
        this.updateImgControl(SELECT_IMG_KEY, "timeimg" + indexHour);
        for (i = indexHour + 1; i < CARD_SUFFIX_ARRAY.size() + 1; ++i) {
            this.updateImgControl(NO_START_IMG_KEY, "timeimg" + i);
        }
        BetweenHour curBetweenHour = CARD_SUFFIX_ARRAY.get(indexHour);
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            int beginHour = betweenHour.beginHour;
            LabelAp label = new LabelAp();
            if (betweenHour == curBetweenHour) {
                label.setForeColor("#FF9400");
            } else {
                label.setForeColor("#999999");
            }
            label.setName(new LocaleString(beginHour + ":00"));
            label.setFontSize(18);
            label.setKey("timelabel" + beginHour);
            this.getView().updateControlMetadata("timelabel" + beginHour, label.createControl());
        }
        String curPanel = "taskpanel" + (LocalTime.now().getHour() / 4 + 1);
        this.getView().updateControlMetadata(curPanel, Collections.singletonMap("bc", "#EFF3FF"));
    }

    private void drawScheduleItem() {
        List<ScheExecItem> execItem = this.getTodayExecItem();
        if (EmptyUtil.isNoEmpty(execItem)) {
            this.panelMap = execItem.stream().collect(Collectors.groupingBy(ScheExecItem::getHourArea));
            List<Tuple<String, TableValueSetter>> tables = this.panelMap.values().stream().map(this::renderingItemArea).collect(Collectors.toList());
            this.fillGridRow(tables);
        }
    }

    private void drawEntryView() {
        if (EmptyUtil.isEmpty(this.panelMap)) {
            return;
        }
        Object frequency = this.getModel().getValue("highfrequency");
        double slot = 240.0 / Double.parseDouble(frequency.toString());
        for (Map.Entry<Integer, List<ScheExecItem>> entry : this.panelMap.entrySet()) {
            String suffix = String.valueOf(entry.getKey() + 1);
            CardEntry cardEntry = (CardEntry)this.getControl("explan" + suffix);
            for (int i = 0; i < entry.getValue().size(); ++i) {
                ScheExecItem item = entry.getValue().get(i);
                cardEntry.setCustomProperties("explan" + suffix, i, Collections.singletonMap("backcardap" + suffix, Collections.singletonMap("bc", ScheduleTodayStatusEnum.getEnumByValue((String)item.getExecResult()).getColor())));
                if (slot >= (double)item.getCount()) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"muchtagap" + suffix});
                }
                if (!EmptyUtil.isBlank((Object)item.getTaskId())) continue;
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"viewlog" + suffix});
            }
        }
    }

    private int checkWhereTime() {
        LocalTime now = LocalTime.now();
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            if (!betweenHour.inHours(now.getHour())) continue;
            int todySecond = now.getHour() * 60 * 60 + now.getMinute() * 60 + now.getSecond();
            int precent = todySecond * 100 / 86400;
            ((ProgressBar)this.getControl("progressbarap5")).setPercent(precent);
            return betweenHour.index;
        }
        return 0;
    }

    private void updateImgControl(String finishImgKey, String imgKey) {
        ImageAp img = new ImageAp();
        img.setKey(imgKey);
        img.setImageKey(finishImgKey);
        img.setImageHoverKey(finishImgKey);
        this.getView().updateControlMetadata(imgKey, img.createControl());
    }

    private List<ScheExecItem> getTodayExecItem() {
        Date startTime = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        Date nextDay = DateUtils.getNextDay((Date)startTime, (int)1);
        List<ScheExecItem> itemList = QueryServiceHelper.query((String)"fcs_schedule_log", (String)"id,createtime,schedule,result", (QFilter[])new QFilter("createtime", ">=", (Object)startTime).toArray()).stream().filter(t -> Objects.nonNull(t.getDate("createtime"))).map(t -> new ScheExecItem(t.getLong("schedule"), t.getDate("createtime"), t.getString("result"), t.getLong("id"))).collect(Collectors.groupingBy(t -> ScheduleTodayStatusEnum.PROCESSING.getValue().equals(t.getExecResult()) + "#" + t.getHourArea() + "#" + t.getScheduleId())).values().stream().filter(EmptyUtil::isNoEmpty).map(this::getLastItem).collect(Collectors.toList());
        Map<Long, String> scheMap = QueryServiceHelper.query((String)"fcs_schedule_proposal", (String)"id,scheplan", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray()).stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getString("scheplan")));
        if (scheMap.isEmpty()) {
            return itemList;
        }
        HashSet<String> planSet = new HashSet<String>(scheMap.values());
        QFilter[] planFilter = new QFilter[]{new QFilter("id", "in", planSet), new QFilter("starttime", "<", (Object)nextDay), new QFilter("endtime", ">", (Object)startTime)};
        Map scheduleMap = QueryServiceHelper.query((String)"sch_schedule", (String)"id,plan,starttime,endtime", (QFilter[])planFilter).stream().collect(Collectors.toMap(t -> t.getString("id"), Function.identity()));
        if (EmptyUtil.isEmpty(scheduleMap)) {
            return itemList;
        }
        List unStart = scheMap.entrySet().stream().flatMap(t -> this.planExecStream((Long)t.getKey(), (DynamicObject)scheduleMap.get(t.getValue()))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(unStart)) {
            itemList.addAll(unStart);
        }
        int curArea = Calendar.getInstance().get(11) / 4;
        Map<Boolean, List<ScheExecItem>> curAreaMap = itemList.stream().collect(Collectors.partitioningBy(t -> curArea == t.getHourArea()));
        List<ScheExecItem> curItemList = curAreaMap.computeIfAbsent(Boolean.TRUE, t -> Collections.emptyList()).stream().collect(Collectors.groupingBy(ScheExecItem::getScheduleId)).values().stream().map(this::mergeStartedSchema).flatMap(Collection::stream).collect(Collectors.toList());
        Optional.ofNullable(curAreaMap.get(Boolean.FALSE)).ifPresent(curItemList::addAll);
        return curItemList;
    }

    private Stream<ScheExecItem> planExecStream(Long schId, DynamicObject plan) {
        if (Objects.isNull(plan)) {
            return Stream.empty();
        }
        return this.getTodayDateList(plan.getString("plan"), plan.getDate("starttime").getTime(), plan.getDate("endtime").getTime()).stream().collect(Collectors.groupingBy(this::getHourArea)).values().stream().filter(EmptyUtil::isNoEmpty).map(t -> this.getFirstElement((List)t, Function.identity(), true)).map(t -> new ScheExecItem(schId, (Date)t.item1, (Integer)t.item2));
    }

    private ScheExecItem getLastItem(List<ScheExecItem> items) {
        Tuple<ScheExecItem, Integer> element = this.getFirstElement(items, ScheExecItem::getExecTime, false);
        ((ScheExecItem)element.item1).setCount((Integer)element.item2);
        return (ScheExecItem)element.item1;
    }

    private <T, U extends Comparable<? super U>> Tuple<T, Integer> getFirstElement(List<T> list, Function<? super T, ? extends U> keyExtractor, boolean inOrder) {
        list.sort(Comparator.comparing(keyExtractor));
        int idx = inOrder ? 0 : list.size() - 1;
        return Tuple.create(list.get(idx), (Object)list.size());
    }

    private List<Date> getTodayDateList(String cron, long startTime, long endTime) {
        ZonedDateTime dateTime;
        Date date;
        long time;
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cron));
        Optional timeOptional = executionTime.nextExecution(ZonedDateTime.now());
        Calendar today = Calendar.getInstance();
        ArrayList<Date> intellExecuteDateList = new ArrayList<Date>(16);
        while (timeOptional.isPresent() && (time = (date = Date.from((dateTime = (ZonedDateTime)timeOptional.get()).toInstant())).getTime()) >= startTime && time < endTime) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(date);
            if (instance.get(6) != today.get(6)) break;
            timeOptional = executionTime.nextExecution((ZonedDateTime)timeOptional.get());
            intellExecuteDateList.add(date);
        }
        return intellExecuteDateList;
    }

    private int getHourArea(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11) / 4;
    }

    private Tuple<String, TableValueSetter> renderingItemArea(List<ScheExecItem> items) {
        items.sort(Comparator.comparing(ScheExecItem::getExecTime));
        int hourArea = items.get(0).getHourArea();
        String suffix = CARD_SUFFIX_ARRAY.get(hourArea).column;
        String entryEntityName = "explan" + suffix;
        SimpleDateFormat dateFormater = new SimpleDateFormat("HH:mm");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("schema" + suffix, new Object[0]);
        vs.addField("cardtime" + suffix, new Object[0]);
        vs.addField("result" + suffix, new Object[0]);
        vs.addField("times" + suffix, new Object[0]);
        vs.addField("taskid" + suffix, new Object[0]);
        items.forEach(obj -> vs.addRow(new Object[]{obj.getScheduleId(), dateFormater.format(obj.getExecTime()), obj.getExecResult(), obj.getCount(), obj.getTaskId()}));
        return Tuple.create((Object)entryEntityName, (Object)vs);
    }

    private void fillGridRow(List<Tuple<String, TableValueSetter>> rows) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        for (Tuple<String, TableValueSetter> tuple : rows) {
            model.batchCreateNewEntryRow((String)tuple.item1, (TableValueSetter)tuple.item2);
        }
        model.endInit();
    }

    private List<ScheExecItem> mergeStartedSchema(List<ScheExecItem> items) {
        return items.stream().collect(Collectors.partitioningBy(t -> ScheduleTodayStatusEnum.PROCESSING.getValue().equals(t.getExecResult()))).values().stream().filter(EmptyUtil::isNoEmpty).map(this::getLastItem).collect(Collectors.toList());
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        String key;
        Object source = evt.getSource();
        if (source instanceof CardEntry && (key = ((CardEntry)source).getKey()).startsWith("explan")) {
            String suffix = key.substring("explan".length());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(key);
            DynamicObject schema = ((DynamicObject)entryEntity.get(evt.getRow())).getDynamicObject("schema" + suffix);
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)schema.getPkValue(), (String)"fcs_schedule_proposal");
            String entity = ScheduleTaskTypeEnum.isOperation((String)dyn.getString("tasktype")) ? "fcs_schedule_bussoper" : "fcs_schedule_task";
            OpenBillHelper.openFormByPKId((IFormView)this.getView(), (Object)dyn.getPkValue(), (String)entity);
        }
    }

    static {
        CARD_SUFFIX_ARRAY.add(new BetweenHour("1", 0, 0, 4));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("2", 1, 4, 8));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("3", 2, 8, 12));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("4", 3, 12, 16));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("5", 4, 16, 20));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("6", 5, 20, 24));
    }

    private static class BetweenHour {
        private String column;
        private int index;
        private int beginHour;
        private int endHour;

        BetweenHour(String column, int index, int beginHour, int endHour) {
            this.column = column;
            this.index = index;
            this.beginHour = beginHour;
            this.endHour = endHour;
        }

        public boolean inHours(int curHour) {
            return curHour >= this.beginHour && curHour < this.endHour;
        }

        public String getColumn() {
            return this.column;
        }
    }
}

