/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.snap;

import java.util.EventObject;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.util.GzipUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SnapDataEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SnapDataEdit.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showSnapData();
        this.getModel().setDataChanged(false);
    }

    private void showSnapData() {
        StringBuilder builder = new StringBuilder();
        String snap_tag = (String)this.getModel().getValue("snap_tag");
        try {
            String snapTag = GzipUtils.uncompress((String)snap_tag, (String)"UTF-8");
            List rows = (List)SerializationUtils.deSerializeFromBase64((String)snapTag);
            for (Row row : rows) {
                if (!EmptyUtil.isNoEmpty((Object)row)) continue;
                String rowVal = "<p>" + row.toString() + "</p>\n";
                builder.append(rowVal);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5feb\u7167\u6570\u636e\u9519\u8bef\uff1a", (Throwable)e);
        }
        RichTextEditor editor = (RichTextEditor)this.getControl("snapdata");
        editor.setText(builder.toString());
    }
}

