/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.snap;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SnapExportSchemeEdit
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("snapscheme_entry");
            if (ObjectUtils.isEmpty((Object)entries)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u201c\u5feb\u7167\u65b9\u6848\u7ec4\u5408\u201d\u5206\u5f55\u81f3\u5c11\u9700\u6709\u4e00\u884c\u6570\u636e\u3002", (String)"SnapExportSchemeEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                for (DynamicObject entry : entries) {
                    if (entry.getDynamicObject("snapscheme") != null) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5feb\u7167\u65b9\u6848\u4e3a\u5fc5\u5f55\u9879\uff0c\u5982\u679c\u4e0d\u8bbe\u7f6e\uff0c\u8bf7\u5c06\u5206\u5f55\u884c\u5220\u9664\u3002", (String)"SnapExportSchemeEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map<String, Long> numberMap = entries.stream().collect(Collectors.groupingBy(e -> e.getString("snapschemenumber"), Collectors.counting()));
                List repeatNumbers = numberMap.keySet().stream().filter(k -> (Long)numberMap.get(k) > 1L).collect(Collectors.toList());
                if (!repeatNumbers.isEmpty()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5feb\u7167\u65b9\u6848%s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SnapExportSchemeEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", repeatNumbers)));
                    args.setCancel(true);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("snapscheme".equals(proName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject snapScheme = (DynamicObject)changeData.getNewValue();
            if (snapScheme != null) {
                this.getModel().setValue("snapschemenumber", (Object)snapScheme.getString("number"), rowIndex);
                this.getModel().setValue("reportform", (Object)snapScheme.getDynamicObject("reportform"), rowIndex);
                this.getModel().setValue("queryscheme", (Object)snapScheme.getDynamicObject("queryscheme"), rowIndex);
                this.getModel().setValue("cmnt", (Object)snapScheme.getString("comment"), rowIndex);
                this.getModel().setValue("schemestatus", (Object)snapScheme.getString("enable"), rowIndex);
                this.getModel().setValue("exportname", (Object)snapScheme.getString("name"), rowIndex);
            }
        }
    }

    public void initialize() {
        Label label = (Label)this.getView().getControl("notice");
        label.setText(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a\u591a\u4e2a\u62a5\u8868\u5feb\u7167\u5c06\u63091\u4efdExcel\u6587\u4ef6\u591a\u4e2aSheet\u9875\u5bfc\u51fa\u3002", (String)"SnapExportSchemeEdit_3", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
    }
}

