/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.snap;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fcs.common.helper.SnapExportExecutor;

public class SnapExportSchemeList
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            long orgId = RequestContext.get().getOrgId();
            commonFilterColumn.setDefaultValue(String.valueOf(orgId));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"exportsnap", (CharSequence)operateKey)) {
            Long schemeId = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)schemeId)) {
                args.setCancel(true);
                return;
            }
            DynamicObject exportScheme = TmcDataServiceHelper.loadSingle((Object)schemeId, (String)"fcs_exportscheme", (String)"enable");
            String enable = exportScheme.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(enable)) {
                return;
            }
            this.openExportParamForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BACK_KEY_EXPORT_PARAMS", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map returnDataMap = (Map)evt.getReturnData();
            String getDataType = (String)returnDataMap.get("getdatatype");
            Date navDate = (Date)returnDataMap.get("date");
            Long schemeId = this.getSelectedId();
            DynamicObject exportSchemeBill = TmcDataServiceHelper.loadSingle((Object)schemeId, (String)"fcs_exportscheme", (String)"name,snapscheme_entry.snapscheme,snapscheme_entry.exportname,snapscheme_entry.schemestatus,snapscheme_entry.reportform");
            SnapExportExecutor executor = new SnapExportExecutor(exportSchemeBill, getDataType, navDate);
            String path = executor.snapExport();
            this.getView().download(path);
        }
    }

    private void openExportParamForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_exoprt_params");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BACK_KEY_EXPORT_PARAMS"));
        this.getView().showForm(showParameter);
    }
}

