/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.snap;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class SnapSchemeList
extends AbstractTmcBillBaseList {
    private static final String FSNAPSCHEMEID = ":fsnapschemeid";
    private static final String FSCHEMESTATUS = ":fschemestatus";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            long orgId = RequestContext.get().getOrgId();
            commonFilterColumn.setDefaultValue(String.valueOf(orgId));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long schemeId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"gensnap", (CharSequence)operateKey) && EmptyUtil.isEmpty((Long)(schemeId = this.getSelectedId()))) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (DISABLE.equals(operateKey) || ENABLE.equals(operateKey)) {
            String enable = DISABLE.equals(operateKey) ? BaseEnableEnum.DISABLE.getValue() : BaseEnableEnum.ENABLE.getValue();
            OperationResult operationResult = args.getOperationResult();
            List billIds = operationResult.getSuccessPkIds().stream().map(o -> Long.valueOf(String.valueOf(o))).collect(Collectors.toList());
            if (!billIds.isEmpty()) {
                ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
                params.add(new SqlParameter(FSCHEMESTATUS, 12, (Object)enable));
                StringBuilder sql = new StringBuilder("update t_fcs_snapscheme_comb set fschemestatus = ? where fsnapschemeid ");
                if (billIds.size() == 1) {
                    sql.append("= ?");
                    params.add(new SqlParameter(FSNAPSCHEMEID, -5, billIds.get(0)));
                } else {
                    sql.append("in (?");
                    params.add(new SqlParameter(FSNAPSCHEMEID, -5, billIds.get(0)));
                    for (int i = 1; i < billIds.size(); ++i) {
                        sql.append(",?");
                        params.add(new SqlParameter(FSNAPSCHEMEID + i, -5, billIds.get(i)));
                    }
                    sql.append(")");
                }
                DB.execute((DBRoute)DBRouteConst.TMC, (String)sql.toString(), (Object[])params.toArray());
            }
        }
    }
}

