/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.snap;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class SnapSchemeParamPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SnapSchemeParamPlugin.class);
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String PARAM_TAG = "param_tag";
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BASEDATATYPE = "basedatatype";
    private static final String PARAMVALUE = "paramvalue";
    private static final String NUMBER = "number";
    private static final String CACHE_KEY_BASE_ENTITY = "baseentitynumber";
    private static final String BASEDATAINFO = "basedatainfo";

    public void registerListener(EventObject e) {
        BasedataEdit typeEdit;
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, PARAMVALUE});
        BasedataEdit valueEdit = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
        if (valueEdit != null) {
            valueEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((typeEdit = (BasedataEdit)this.getView().getControl(BASEDATATYPE)) != null) {
            typeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        Object basedataType;
        String propName = event.getProperty().getName();
        if (BASEDATAVALUE.equals(propName) && (basedataType = this.getModel().getValue(BASEDATATYPE)) == null) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"SnapSchemeParamPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        }
        if (BASEDATATYPE.equals(propName)) {
            List filters = event.getCustomQFilters();
            filters.add(new QFilter("type", "!=", (Object)"2"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String boxKey = (String)parameter.getCustomParam("visible");
        String value = (String)parameter.getCustomParam("value");
        List keyList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)boxKey)) {
            keyList = (List)SerializationUtils.fromJsonString((String)boxKey, List.class);
        }
        if (keyList.size() == 1) {
            this.getPageCache().put(PARAM_TAG, (String)keyList.get(0));
        } else if (keyList.size() == 2 && keyList.contains(BASEDATAVALUE)) {
            this.getPageCache().put(PARAM_TAG, BASEDATAVALUE);
        }
        for (String key : keyList) {
            if (!StringUtils.equals((CharSequence)BASEDATATYPE, (CharSequence)key) && !StringUtils.equals((CharSequence)BASEDATAVALUE, (CharSequence)key)) {
                this.getModel().setValue(key, (Object)value);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{key});
        }
        String basedataInfo = (String)parameter.getCustomParam(BASEDATAINFO);
        if (StringUtils.isNotBlank((CharSequence)basedataInfo)) {
            Map basedataMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class);
            Map basedataTypeMap = (Map)basedataMap.get(BASEDATATYPE);
            Map basedataValueMap = (Map)basedataMap.get(BASEDATAVALUE);
            if (basedataTypeMap != null && basedataValueMap != null) {
                Object id;
                Object pkId = basedataTypeMap.get("id");
                DynamicObject basedataTypeDy = BusinessDataServiceHelper.loadSingleFromCache(pkId, (String)"bos_formmeta");
                this.getModel().setValue(BASEDATATYPE, (Object)basedataTypeDy);
                String basedataValueNumber = (String)basedataValueMap.get(NUMBER);
                this.getPageCache().put(CACHE_KEY_BASE_ENTITY, basedataValueNumber);
                BasedataEdit basedataValue = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
                BasedataProp basedataProp = (BasedataProp)basedataValue.getProperty();
                if (StringUtils.isNotBlank((CharSequence)basedataValueNumber)) {
                    basedataProp.setBaseEntityId(basedataValueNumber);
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataValueNumber);
                    basedataProp.setComplexType((IDataEntityType)dataEntityType);
                }
                if ((id = basedataValueMap.get("id")) != null) {
                    this.getModel().setValue(BASEDATAVALUE, id);
                }
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        Map basedataInfoMap;
        Object basedataDef;
        super.getEntityType(e);
        String basedataInfo = (String)this.getView().getFormShowParameter().getCustomParam(BASEDATAINFO);
        if (StringUtils.isNotBlank((CharSequence)basedataInfo) && (basedataDef = (basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class)).get(BASEDATAVALUE)) != null) {
            Map basedataDefMap = (Map)basedataDef;
            String baseEntity = (String)basedataDefMap.get(NUMBER);
            this.setEntityType(e, baseEntity);
        }
        String baseEntity = this.getPageCache().get(CACHE_KEY_BASE_ENTITY);
        this.setEntityType(e, baseEntity);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (BASEDATATYPE.equals(propName)) {
            this.getModel().setValue(BASEDATAVALUE, null);
            BasedataEdit basedataValue = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
            BasedataProp basedataProp = (BasedataProp)basedataValue.getProperty();
            DynamicObject basedataType = (DynamicObject)this.getModel().getValue(BASEDATATYPE);
            if (basedataType == null) {
                return;
            }
            String fnumber = (String)basedataType.get(NUMBER);
            this.getPageCache().put(CACHE_KEY_BASE_ENTITY, fnumber);
            if (StringUtils.isNotBlank((CharSequence)fnumber)) {
                basedataProp.setBaseEntityId(fnumber);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fnumber);
                basedataProp.setComplexType((IDataEntityType)dataEntityType);
            }
            this.getView().updateView();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String paramTag = this.getPageCache().get(PARAM_TAG);
        if (CONFIRM.equals(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(4);
            if (BASEDATAVALUE.equals(paramTag)) {
                HashMap<String, Object> basedataInfoMap = new HashMap<String, Object>(16);
                BasedataProp basedataProp = (BasedataProp)this.getModel().getProperty(paramTag);
                DynamicObject basedataType = (DynamicObject)this.getModel().getValue(BASEDATATYPE);
                if (basedataType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"SnapSchemeParamPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> basedataTypeMap = new HashMap<String, Object>(4);
                basedataTypeMap.put(NUMBER, "bos_formmeta");
                basedataTypeMap.put("id", basedataType.getPkValue());
                Object pkId = this.getModel().getValue("basedatavalue_id");
                String entityId = basedataProp.getBaseEntityId();
                HashMap<String, Object> basedataValueMap = new HashMap<String, Object>(4);
                basedataValueMap.put(NUMBER, entityId);
                if (StringUtils.isNotBlank((Object)pkId) && 0L != (Long)pkId) {
                    basedataValueMap.put("id", pkId);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
                    String nameProp = ((BasedataEntityType)dynamicObject.getDataEntityType()).getNameProperty();
                    Object nameValue = dynamicObject.get(nameProp);
                    String nameStr = nameValue != null ? nameValue.toString() : "";
                    basedataInfoMap.put(PARAMVALUE, nameStr);
                }
                basedataInfoMap.put(BASEDATAVALUE, basedataValueMap);
                basedataInfoMap.put(BASEDATATYPE, basedataTypeMap);
                basedataInfoMap.put("type", "basedata");
                returnData.put("returnData", basedataInfoMap);
                this.getPageCache().remove(CACHE_KEY_BASE_ENTITY);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(paramTag))) {
                returnData.put(PARAMVALUE, "");
            } else {
                String paramDefValue;
                HashMap<String, String> dataMap = new HashMap<String, String>(4);
                switch (paramTag) {
                    case "datetype": {
                        Date date = (Date)this.getModel().getValue("datetype");
                        paramDefValue = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                        break;
                    }
                    case "datetimetype": {
                        Date dateTime = (Date)this.getModel().getValue("datetimetype");
                        paramDefValue = DateUtils.formatString((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
                        break;
                    }
                    case "timetype": {
                        Integer timeType = (Integer)this.getModel().getValue("timetype");
                        paramDefValue = this.formatDuration(timeType);
                        break;
                    }
                    case "booleantype": {
                        paramDefValue = StringUtils.equals((CharSequence)"1", (CharSequence)((String)this.getModel().getValue("booleantype"))) ? "true" : "false";
                        break;
                    }
                    default: {
                        paramDefValue = String.valueOf(this.getModel().getValue(paramTag));
                    }
                }
                dataMap.put("type", "text");
                dataMap.put(PARAMVALUE, paramDefValue);
                returnData.put("returnData", dataMap);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    private void setEntityType(GetEntityTypeEventArgs e, String baseEntity) {
        if (StringUtils.isNotBlank((CharSequence)baseEntity)) {
            MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)baseEntity);
            MainEntityType mainType = null;
            try {
                mainType = (MainEntityType)e.getOriginalEntityType().clone();
            }
            catch (CloneNotSupportedException ex) {
                log.error(ex.getMessage());
            }
            if (mainType != null) {
                BasedataProp baseProp = (BasedataProp)mainType.findProperty(BASEDATAVALUE);
                baseProp.setComplexType((IDataEntityType)baseType);
                baseProp.setBaseEntityId(baseType.getName());
                DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainType.findProperty(baseProp.getRefIdProp().getName());
                mainType.getProperties().remove((Object)refIdProp);
                refIdProp = baseProp.createRefIDProp();
                refIdProp.setPrimaryKey(false);
                if (StringUtils.isBlank((CharSequence)baseProp.getAlias())) {
                    refIdProp.setDbIgnore(true);
                } else {
                    refIdProp.setAlias(baseProp.getAlias());
                    refIdProp.setTableGroup(baseProp.getTableGroup());
                }
                refIdProp.setName(baseProp.getName() + "_id");
                mainType.addProperty((DynamicProperty)refIdProp);
                baseProp.setRefIdPropName(baseProp.getName() + "_id");
                baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
                e.setNewEntityType(mainType);
            }
        }
    }

    private String formatDuration(int duration) {
        if (duration == 0) {
            return "00:00:00";
        }
        String time = String.format("%02d:%2$02d:%3$02d", duration / 3600, duration % 3600 / 60, duration % 60);
        return time;
    }
}

