/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.suspect;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MatchSchemeEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"destfieldname", "checkfieldname"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String proKey = source.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        switch (proKey) {
            case "destfieldname": {
                String destEntity = (String)customParams.get("destentity");
                this.showSelectFieldForm(destEntity, proKey);
                break;
            }
            case "checkfieldname": {
                String checkEntity = (String)customParams.get("checkentity");
                this.showSelectFieldForm(checkEntity, proKey);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key = e.getActionId();
        String returnData = (String)e.getReturnData();
        switch (key) {
            case "destfieldname": {
                if (!EmptyUtil.isNoEmpty((String)returnData)) break;
                String[] returnDatas = returnData.split(",");
                this.getModel().setValue("destfieldname", (Object)returnDatas[1]);
                this.getModel().setValue("destfield", (Object)returnDatas[0]);
                break;
            }
            case "checkfieldname": {
                if (!EmptyUtil.isNoEmpty((String)returnData)) break;
                String[] returnDatas = returnData.split(",");
                this.getModel().setValue("checkfieldname", (Object)returnDatas[1]);
                this.getModel().setValue("checkfield", (Object)returnDatas[0]);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String record = (String)customParams.get("matchrecord_tag");
        if (EmptyUtil.isNoEmpty((String)record)) {
            List matchList = SerializationUtils.fromJsonStringToList((String)record, Map.class);
            DynamicObjectCollection matchEntity = this.getModel().getEntryEntity("matchentity");
            for (int i = 0; i < matchList.size(); ++i) {
                if (i >= matchEntity.size()) {
                    matchEntity.addNew();
                }
                this.getModel().setValue("destfieldname", ((Map)matchList.get(i)).get("destname"), i);
                this.getModel().setValue("destfield", ((Map)matchList.get(i)).get("destkey"), i);
                this.getModel().setValue("matchrule", (Object)"=", i);
                this.getModel().setValue("checkfieldname", ((Map)matchList.get(i)).get("checkname"), i);
                this.getModel().setValue("checkfield", ((Map)matchList.get(i)).get("checkkey"), i);
                this.getModel().setValue("shortfieldname", ((Map)matchList.get(i)).get("shortname"), i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("ok".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            ArrayList returnData = new ArrayList(10);
            DynamicObjectCollection matchEntity = this.getModel().getEntryEntity("matchentity");
            for (DynamicObject row : matchEntity) {
                HashMap<String, String> match = new HashMap<String, String>(4);
                match.put("destkey", row.getString("destfield"));
                match.put("destname", row.getString("destfieldname"));
                match.put("checkkey", row.getString("checkfield"));
                match.put("checkname", row.getString("checkfieldname"));
                match.put("shortname", row.getString("shortfieldname"));
                returnData.add(match);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().close();
        }
    }

    private void showSelectFieldForm(String entityNumber, String sourceCtrlKey) {
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityNumber);
        option.setIncludeBDPropPK(false);
        option.setIncludePKField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tmc_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

