/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.suspect;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.EntryHyperLinkClickEvent;
import kd.bos.form.events.EntryHyperLinkClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;
import kd.tmc.fcs.formplugin.suspect.AbstractSuspectListPlugin;

public class SuspectConfirmPlugin
extends AbstractSuspectListPlugin
implements HyperLinkClickListener,
EntryHyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(SuspectConfirmPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addEntryHyperLinkClickListener((EntryHyperLinkClickListener)this);
        QFilter qFilter = this.getQFilter();
        billList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        QFilter qFilter = this.getQFilter();
        billList.getFilterParameter().getQFilters().add(qFilter);
        billList.refreshData();
    }

    private QFilter getQFilter() {
        JSONArray billIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("billid");
        if (billIds != null) {
            QFilter qFilter = new QFilter("billid", "in", (Object)billIds);
            qFilter.and("ctrltype", "=", (Object)SuspectCtrlTypeEnum.LANDING.getValue());
            qFilter.and("confirm", "=", (Object)false);
            return qFilter;
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("billno".equals(evt.getFieldName())) {
            this.showDestBill();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter qFilter = this.getQFilter();
        List allSuspectBills = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id", (QFilter[])qFilter.toArray()).stream().map(s -> s.get("id")).collect(Collectors.toList());
        this.getView().getPageCache().put("allSuspectBills", SerializationUtils.toJsonString(allSuspectBills));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("confirm".equals(formOperate.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("operate", "confirm");
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u7591\u4f3c\u91cd\u590d\u8bb0\u5f55\u540e\u518d\u64cd\u4f5c\u3002", (String)"SuspectBillListPlugin_3", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List allSuspectBills = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("allSuspectBills"), Object.class);
            List selectedBillIds = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            logger.info("\u7591\u4f3c\u91cd\u590d\u786e\u8ba4\u9009\u4e2did:" + selectedBillIds.toString());
            List notSelectedBillIds = allSuspectBills;
            notSelectedBillIds.removeAll(selectedBillIds);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,billentity.number", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedBillIds)});
            Object[] confirmSuspectBills = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
            logger.info("\u67e5\u51fa\u7684\u786e\u8ba4\u7591\u4f3c\u91cd\u590d\u6570\u636e\uff1a" + Arrays.toString(confirmSuspectBills));
            if (EmptyUtil.isEmpty((Object[])confirmSuspectBills) || confirmSuspectBills.length != new HashSet(selectedBillIds).size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u548c\u6570\u636e\u5e93\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SuspectBillListPlugin_4", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                billList.getSelectedRows().clear();
                billList.refreshData();
                args.setCancel(true);
                return;
            }
            Set confirmBilllIds = Arrays.stream(confirmSuspectBills).map(s -> s.getLong("billid")).collect(Collectors.toSet());
            Set<Object> notConfirmBilllIds = new HashSet(10);
            if (notSelectedBillIds.size() > 0) {
                DynamicObjectCollection queryCollection = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,billentity.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)notSelectedBillIds)});
                DynamicObject[] notConfirmSuspectBills = (DynamicObject[])queryCollection.toArray((Object[])new DynamicObject[0]);
                notConfirmBilllIds = Arrays.stream(notConfirmSuspectBills).map(s -> s.getLong("billid")).collect(Collectors.toSet());
                HashSet repeatIds = new HashSet(confirmBilllIds);
                repeatIds.retainAll(notConfirmBilllIds);
                if (repeatIds.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u5168\u90e8\u786e\u8ba4\u7684\u7591\u4f3c\u91cd\u590d\u5355\u636e\u8bb0\u5f55\uff0c\u8bf7\u5168\u90e8\u786e\u8ba4\u3002", (String)"SuspectConfirmPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            returnData.put("executeOperate", this.getView().getFormShowParameter().getCustomParam("executeOperate"));
            String entityNumber = confirmSuspectBills[0].getString("billentity.number");
            returnData.put("billentity", entityNumber);
            returnData.put("notConfirmBilllIds", notConfirmBilllIds);
            logger.info("\u8fd4\u56de\u7684\u7591\u4f3c\u91cd\u590ddata\uff1a" + ((Object)returnData).toString());
            HashMap writeBackIds = new HashMap(4);
            writeBackIds.put(entityNumber, confirmBilllIds);
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"suspectRepeatService", (String)"updateSuspectRepeatInfo", (Object[])new Object[]{selectedBillIds, writeBackIds, "1"});
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().getPageCache().put("operate", "confirm");
        } else if ("close".equals(formOperate.getOperateKey())) {
            this.getView().getPageCache().put("operate", "close");
            this.getView().close();
        }
    }

    private void executeOperate() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        List allSuspectBills = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("allSuspectBills"), Object.class);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,billentity.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allSuspectBills)});
        DynamicObject[] allSuspectBillsObj = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
        Set allBilllIds = Arrays.stream(allSuspectBillsObj).map(s -> s.getLong("billid")).collect(Collectors.toSet());
        returnData.put("executeOperate", this.getView().getFormShowParameter().getCustomParam("executeOperate"));
        String entityNumber = allSuspectBillsObj[0].getString("billentity.number");
        returnData.put("billentity", entityNumber);
        returnData.put("notConfirmBilllIds", allBilllIds);
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String operate = this.getView().getPageCache().get("operate");
        if (!"confirm".equals(operate)) {
            this.executeOperate();
        }
    }

    public void hyperLinkClick(EntryHyperLinkClickEvent evt) {
        DynamicObjectCollection suspectentry;
        List selectedEntry;
        long billPK = Long.parseLong(evt.getPk().toString());
        Object entryPk = evt.getEntryPk();
        QFilter qFilter = new QFilter("id", "=", (Object)billPK);
        Object[] fcs_suspectbills = BusinessDataServiceHelper.load((String)"fcs_suspectbill", (String)"id,suspectentry,suspectentry.suspectbillno,suspectentry.suspectbillid,suspectentry.suspectbillentity", (QFilter[])new QFilter[]{qFilter});
        if (!EmptyUtil.isEmpty((Object[])fcs_suspectbills) && !EmptyUtil.isEmpty(selectedEntry = (suspectentry = fcs_suspectbills[0].getDynamicObjectCollection("suspectentry")).stream().filter(e -> entryPk.equals(e.getPkValue())).collect(Collectors.toList()))) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)((DynamicObject)selectedEntry.get(0)).getLong("suspectbillid"));
            parameter.setFormId(((DynamicObject)selectedEntry.get(0)).getDynamicObject("suspectbillentity").getString("number"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

