/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.suspect;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;
import kd.tmc.fcs.common.helper.BillOperationHelper;
import kd.tmc.fcs.common.property.OpreatTypeProp;

public class SuspectSetEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"checksignfield", "messagefield", "matchscheme", "destfilter", "checkfilter"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propkey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (propkey) {
            case "ctrltype": {
                if (!changeSet[0].getNewValue().toString().equals(SuspectCtrlTypeEnum.WARNING.getValue())) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"landingop"});
                    break;
                }
                this.getModel().setValue("landingop", null);
                break;
            }
            case "destentity": {
                DynamicObject destEntity = (DynamicObject)this.getModel().getValue("destentity");
                if (EmptyUtil.isNoEmpty((DynamicObject)destEntity)) {
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), (List)OpreatTypeProp.suspectWhiteList, (String[])new String[]{"landingop"});
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), (List)OpreatTypeProp.whiteList, (String[])new String[]{"checkop"});
                }
                this.getModel().setValue("checkop", null);
                this.getModel().setValue("landingop", null);
                this.getModel().deleteEntryData("matchentity");
                break;
            }
            case "checkentity": {
                this.getModel().deleteEntryData("matchentity");
                break;
            }
            case "checkop": {
                String checkop = (String)this.getModel().getValue(propkey);
                if (!EmptyUtil.isNoEmpty((String)checkop)) break;
                List<String> checkOp = Arrays.asList(checkop.replaceFirst(",", "").split(","));
                this.getModel().setValue("checkopname", (Object)BillOperationHelper.getOpNameBykey((IFormView)this.getView(), checkOp, (String)propkey));
                break;
            }
            case "landingop": {
                String landingop = (String)this.getModel().getValue(propkey);
                if (EmptyUtil.isNoEmpty((String)landingop)) {
                    List<String> LandingOp = Arrays.asList(landingop.replaceFirst(",", "").split(","));
                    this.getModel().setValue("landingopname", (Object)BillOperationHelper.getOpNameBykey((IFormView)this.getView(), LandingOp, (String)propkey));
                    break;
                }
                this.getModel().setValue("landingopname", null);
                break;
            }
            case "destfilter": 
            case "checkfilter": {
                String describe = (String)this.getModel().getValue(propkey);
                if (!EmptyUtil.isEmpty((String)describe)) break;
                this.getModel().setValue(propkey + "record_tag", null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("destentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)destEntity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), (List)OpreatTypeProp.suspectWhiteList, (String[])new String[]{"landingop"});
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), (List)OpreatTypeProp.whiteList, (String[])new String[]{"checkop"});
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String proKey = source.getKey();
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("destentity");
        DynamicObject checkEntity = (DynamicObject)this.getModel().getValue("checkentity");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("matchentity");
        switch (proKey) {
            case "checksignfield": 
            case "messagefield": {
                this.showSelectField(proKey, destEntity);
                break;
            }
            case "matchscheme": {
                boolean destNotNull = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"destentity");
                boolean checkNotNull = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"checkentity");
                if (!destNotNull || !checkNotNull) break;
                String matchRecord = (String)this.getModel().getValue("matchrecord_tag");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fcs_matchscheme");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.getCustomParams().put("destentity", destEntity.getString("number"));
                showParameter.getCustomParams().put("checkentity", checkEntity.getString("number"));
                showParameter.getCustomParams().put("matchrecord_tag", matchRecord);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, proKey));
                this.getView().showForm(showParameter);
                break;
            }
            case "destfilter": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"destentity")) break;
                String destJson = (String)this.getModel().getValue("destfilterrecord_tag", rowIndex);
                this.openFilter(destEntity.getString("number"), destJson, proKey);
                break;
            }
            case "checkfilter": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"checkentity")) break;
                String checkJson = (String)this.getModel().getValue("checkfilterrecord_tag", rowIndex);
                this.openFilter(checkEntity.getString("number"), checkJson, proKey);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("matchentity");
        if (EmptyUtil.isNoEmpty((Object)returnData)) {
            switch (e.getActionId()) {
                case "checksignfield": 
                case "messagefield": {
                    this.getModel().setValue(e.getActionId(), (Object)returnData.toString().split(",")[0]);
                    break;
                }
                case "destfilter": {
                    this.getModel().setValue("destfilterrecord_tag", returnData, rowIndex);
                    this.setFilterDescribe("destfilter", returnData, rowIndex);
                    break;
                }
                case "checkfilter": {
                    this.getModel().setValue("checkfilterrecord_tag", returnData, rowIndex);
                    this.setFilterDescribe("checkfilter", returnData, rowIndex);
                    break;
                }
                case "matchscheme": {
                    this.getModel().setValue("matchrecord_tag", returnData, rowIndex);
                    List matchList = SerializationUtils.fromJsonStringToList((String)returnData.toString(), Map.class);
                    StringBuilder sb = new StringBuilder();
                    matchList.forEach(m -> sb.append(" and ").append(m.get("destname")).append(" ").append(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"SuspectSetEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0])).append(" ").append(m.get("checkname")));
                    sb.delete(0, 5);
                    String describe = sb.toString();
                    if (describe.length() > 50) {
                        describe = describe.substring(0, 40) + "......";
                    }
                    this.getModel().setValue("matchscheme", (Object)describe, rowIndex);
                }
            }
        }
    }

    private void setFilterDescribe(String propName, Object returnData, int rowIndex) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData.toString(), CRCondition.class);
        String desc = condition.getExprDesc();
        if (desc.length() > 50) {
            desc = desc.substring(0, 40) + "......";
        }
        this.getModel().setValue(propName, (Object)desc, rowIndex);
    }

    private void showSelectField(String key, DynamicObject destEntity) {
        if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"destentity")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tmc_selectfield");
            MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)destEntity.getString("number"));
            PropTreeBuildOption option = key.equals("checksignfield") ? new PropTreeBuildOption(null, BooleanProp.class) : new PropTreeBuildOption(null, TextProp.class);
            option.setCurrentEntity(destEntity.getString("number"));
            option.setIncludeChildEntity(false);
            option.setIncludeBDPropPK(false);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
            String toJson = SerializationUtils.toJsonString((Object)treeNode);
            showParameter.getCustomParams().put("treenodes", toJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void openFilter(String billEntity, String conditionJson, String conditionDescCtrlKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billEntity);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fieldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fieldNodes, conditionDescCtrlKey);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

