/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.task;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.BillOperationHelper;

public class TaskConfigEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizentity = (BasedataEdit)this.getControl("mainentity");
        bizentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"microservice"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map initData = (Map)formShowParameter.getCustomParams().get("initdata");
        if (EmptyUtil.isNoEmpty((Object)initData)) {
            this.getModel().setValue("appid", initData.get("appid"));
            this.getModel().setValue("mainentity", initData.get("mainentity"));
            this.getModel().setValue("operatekey", initData.get("operatekey"));
            this.getModel().setValue("operatename", initData.get("operatename"));
            this.getModel().setValue("microservice", initData.get("microservice"));
            this.getModel().setValue("mserviceconfig_tag", initData.get("mserviceconfig_tag"));
            this.getModel().setValue("taskname", initData.get("taskname"));
            this.getModel().setValue("iscycle", initData.get("iscycle"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("ok".equals(operate.getOperateKey())) {
            boolean checkInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"appid", "mainentity", "operatekey", "taskname"});
            args.setCancel(!checkInput);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("ok".equals(operateKey)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map initData = (Map)formShowParameter.getCustomParams().get("initdata");
            if (EmptyUtil.isNoEmpty((Object)initData)) {
                returnData.put("index", initData.get("index"));
            }
            DynamicObject appid = (DynamicObject)this.getModel().getValue("appid");
            DynamicObject entity = (DynamicObject)this.getModel().getValue("mainentity");
            returnData.put("appid", EmptyUtil.isNoEmpty((DynamicObject)appid) ? appid.getString("id") : null);
            returnData.put("mainentity", EmptyUtil.isNoEmpty((DynamicObject)entity) ? entity.getString("id") : null);
            returnData.put("operatekey", this.getModel().getValue("operatekey"));
            returnData.put("operatename", this.getModel().getValue("operatename"));
            returnData.put("microservice", this.getModel().getValue("microservice"));
            returnData.put("mserviceconfig_tag", this.getModel().getValue("mserviceconfig_tag"));
            returnData.put("taskname", this.getModel().getValue("taskname"));
            returnData.put("iscycle", this.getModel().getValue("iscycle"));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject mainEnity = (DynamicObject)this.getModel().getValue("mainentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)mainEnity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)mainEnity.getString("number"), null, (String[])new String[]{"operatekey"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        DynamicObject mainEnity = (DynamicObject)this.getModel().getValue("mainentity");
        switch (propKey) {
            case "appid": {
                this.getModel().setValue("mainentity", null);
                this.getModel().setValue("operatekey", null);
                break;
            }
            case "mainentity": {
                String entityName = "";
                if (EmptyUtil.isNoEmpty((DynamicObject)mainEnity)) {
                    entityName = mainEnity.getString("name");
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)mainEnity.getString("number"), null, (String[])new String[]{"operatekey"});
                } else {
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), null, null, (String[])new String[]{"operatekey"});
                }
                this.getModel().setValue("operatekey", null);
                this.getModel().setValue("taskname", (Object)entityName.substring(0, Math.min(12, entityName.length())));
                break;
            }
            case "operatename": {
                String taskName = "";
                if (EmptyUtil.isNoEmpty((DynamicObject)mainEnity)) {
                    taskName = mainEnity.getString("name") + this.getModel().getValue("operatename");
                }
                this.getModel().setValue("taskname", (Object)taskName.substring(0, Math.min(12, taskName.length())));
                break;
            }
            case "operatekey": {
                String operateKey = (String)this.getModel().getValue("operatekey");
                if (EmptyUtil.isNoEmpty((String)operateKey)) {
                    List<String> opList = Arrays.asList(operateKey.replaceFirst(",", "").split(","));
                    String operateName = BillOperationHelper.getOpNameBykey((IFormView)this.getView(), opList, (String)"operatekey").replace("\uff1b", "");
                    this.getModel().setValue("operatename", (Object)operateName);
                    break;
                }
                this.getModel().setValue("operatename", null);
                break;
            }
            case "microservice": {
                String microservice = (String)this.getModel().getValue("microservice");
                if (!EmptyUtil.isEmpty((String)microservice)) break;
                this.getModel().setValue("mserviceconfig_tag", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("mainentity".equals(key) && TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"appid")) {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("bizappid", "=", ((DynamicObject)this.getModel().getValue("appid")).getPkValue());
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String proKey = source.getKey();
        if ("microservice".equals(proKey)) {
            boolean checkInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"mainentity");
            if (!checkInput) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            DynamicObject mainEntity = (DynamicObject)this.getModel().getValue("mainentity");
            parameter.setFormId("fcs_microservice");
            parameter.setCustomParam("entity", mainEntity.get("id"));
            parameter.setCustomParam("entityNumber", mainEntity.get("number"));
            parameter.setCustomParam("eventnumber", (Object)"eventnumber");
            parameter.setCustomParam("type", (Object)"cosmic");
            parameter.setCustomParam("config", this.getModel().getValue("mserviceconfig_tag"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mserviceconfig"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        JSONObject returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("mserviceconfig".equals(actionId) && (returnData = (JSONObject)event.getReturnData()) != null) {
            this.getModel().setValue("mserviceconfig_tag", (Object)returnData);
            this.getModel().setValue("microservice", returnData.get((Object)"servicename"));
        }
    }
}

