/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.task;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.TaskExecuteStatusEnum;

public class TaskExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHEKEY_TASKID = "taskflow_taskid";
    private static final String TASKFLOW = "taskflow";

    public void registerListener(EventObject e) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"close"});
    }

    public void afterCreateNewData(EventObject e) {
        String taskJson = (String)this.getView().getFormShowParameter().getCustomParams().get(TASKFLOW);
        Object[] task = DynamicObjectSerializeUtil.deserialize((String)taskJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fcs_taskflow"));
        this.showInitProgress((DynamicObject)task[0]);
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.showExecuteProgress(taskInfo);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getControl("progress");
        bar.start();
        String taskId = this.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            bar.setPercent(100);
        } else {
            bar.setPercent(taskInfo.getProgress());
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        if (EmptyUtil.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        this.showExecuteProgress(taskInfo);
        if (taskInfo.isTaskEnd()) {
            e.setProgress(100);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                e.setProgress(99);
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("close".equals(c.getKey())) {
            this.getView().close();
        }
    }

    private void showInitProgress(DynamicObject taskFlow) {
        for (DynamicObject task : taskFlow.getDynamicObjectCollection("taskentry")) {
            DynamicObject mainentity = task.getDynamicObject("mainentity");
            int index = this.getModel().createNewEntryRow("entrys");
            this.getModel().setValue("mainentity", (Object)mainentity, index);
            this.getModel().setValue("operatekey", (Object)task.getString("operatekey"), index);
            this.getModel().setValue("operatename", (Object)task.getString("operatename"), index);
            this.getModel().setValue("result", (Object)TaskExecuteStatusEnum.NONEXECUTE.getValue(), index);
        }
    }

    private void showExecuteProgress(TaskInfo taskInfo) {
        String taskInfoData = taskInfo.getData();
        if (EmptyUtil.isNoEmpty((String)taskInfoData)) {
            Map resultData = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
            EntryGrid grid = (EntryGrid)this.getControl("entrys");
            DynamicObject[] tasks = grid.getEntryData().getDataEntitys();
            for (int seq = 0; seq < tasks.length; ++seq) {
                String result = (String)resultData.get("result" + seq);
                if (!EmptyUtil.isNoEmpty((String)result)) continue;
                this.getModel().setValue("result", (Object)result, seq);
                if (resultData.containsKey("sucesscount" + seq)) {
                    this.getModel().setValue("sucesscount", (Object)String.valueOf(resultData.get("sucesscount" + seq)), seq);
                }
                if (TaskExecuteStatusEnum.FAIL.getValue().equals(result) && resultData.containsKey("exception" + seq)) {
                    this.getModel().setValue("exception", resultData.get("exception" + seq), seq);
                }
                this.getView().updateView("result", seq);
            }
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }
}

