/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.BillOperationHelper;
import kd.tmc.fcs.common.helper.ConditionHelper;

public class TaskFlowEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bizfilter", "addcard", "addimg", "addlabel", "deletetlap", "modifilap", "addorg"});
        BasedataEdit bizapp = (BasedataEdit)this.getControl("bizappid");
        bizapp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizentity = (BasedataEdit)this.getControl("bizentity");
        bizentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String proKey = source.getKey();
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        switch (proKey) {
            case "bizfilter": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizentity")) break;
                String destJson = (String)this.getModel().getValue("bizfilterconfig_tag");
                ConditionHelper.openFilter((String)bizEntity.getString("number"), (String)destJson, (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, proKey));
                break;
            }
            case "addcard": 
            case "addimg": 
            case "addlabel": {
                this.showTaskConfig("addtask", null);
                break;
            }
            case "modifilap": {
                int index = this.getModel().getEntryCurrentRowIndex("taskentry");
                Map<String, Object> curOperData = this.getCurrentTask(index);
                this.showTaskConfig("modifytask", curOperData);
                break;
            }
            case "deletetlap": {
                int focusRow = this.getModel().getEntryCurrentRowIndex("taskentry");
                this.getModel().deleteEntryRow("taskentry", focusRow);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        if ("addtask".equals(actionId)) {
            Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            int index = this.getModel().createNewEntryRow("taskentry");
            this.setTask(returnMap, index);
        } else if ("modifytask".equals(actionId)) {
            Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            this.setTask(returnMap, (Integer)returnMap.get("index"));
        } else if ("addorg".equals(actionId)) {
            this.addOrg(event);
        } else if ("bizfilter".equals(actionId)) {
            this.getModel().setValue("bizfilterconfig_tag", returnData);
            ConditionHelper.setFilterDescribe((Object)returnData, (IDataModel)this.getModel());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("exceptionreceiver", (Object)RequestContext.get().getCurrUserId());
    }

    public void afterBindData(EventObject e) {
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizEntity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)bizEntity.getString("number"), null, (String[])new String[]{"beginoperate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "bizentity": {
                DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
                if (EmptyUtil.isNoEmpty((DynamicObject)bizEntity)) {
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)bizEntity.getString("number"), null, (String[])new String[]{"beginoperate"});
                } else {
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), null, null, (String[])new String[]{"beginoperate"});
                }
                this.getModel().setValue("bizfilterconfig_tag", null);
                this.getModel().setValue("bizfilter", null);
                break;
            }
            case "beginoperate": {
                String opKey = (String)this.getModel().getValue("beginoperate");
                String opName = BillOperationHelper.getOpNameBykey((IFormView)this.getView(), Collections.singletonList(opKey), (String)"beginoperate").replace("\uff1b", "");
                this.getModel().setValue("beginoperatename", (Object)opName);
                break;
            }
            case "bizappid": {
                this.getModel().setValue("bizentity", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "bizentity": {
                if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizappid")) {
                    QFilter qFilter = new QFilter("bizappid", "=", ((DynamicObject)this.getModel().getValue("bizappid")).getPkValue());
                    sp.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                evt.setCancel(true);
                break;
            }
            case "org": {
                sp.setMultiSelect(Boolean.TRUE.booleanValue());
                sp.getListFilterParameter().getQFilters().add(this.getSelectOrgQFilter());
                break;
            }
            case "bizappid": {
                sp.getCustomParams().put("onlydeployed", Boolean.FALSE);
                sp.getListFilterParameter().getQFilters().add(new QFilter("number", "not like", (Object)"%ext%"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("addorg".equals(args.getOperateKey())) {
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setBillFormId("bos_org");
            para.setFormId("bos_orgtreelistf7");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowTitle(false);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addorg"));
            para.getListFilterParameter().getQFilters().add(this.getSelectOrgQFilter());
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private QFilter getSelectOrgQFilter() {
        DynamicObjectCollection orgInfos = this.getModel().getEntryEntity("orgentry");
        ArrayList<Object> list = new ArrayList<Object>(orgInfos.size());
        for (DynamicObject orgInfo : orgInfos) {
            DynamicObject org = orgInfo.getDynamicObject("org");
            if (!EmptyUtil.isNoEmpty((DynamicObject)org)) continue;
            list.add(org.getPkValue());
        }
        return new QFilter("id", "not in", list);
    }

    private void addOrg(ClosedCallBackEvent event) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)event.getReturnData();
        ArrayList<Object> newOrgList = new ArrayList<Object>(rowDataCol.size());
        for (ListSelectedRow selectrow : rowDataCol) {
            if (!EmptyUtil.isNoEmpty((Object)selectrow.getPrimaryKeyValue())) continue;
            newOrgList.add(selectrow.getPrimaryKeyValue());
        }
        if (EmptyUtil.isNoEmpty(newOrgList)) {
            int[] rowIndexs = this.getModel().batchCreateNewEntryRow("orgentry", newOrgList.size());
            for (int i = 0; i < rowIndexs.length; ++i) {
                this.getModel().setValue("org", newOrgList.get(i), rowIndexs[i]);
            }
        }
    }

    private void showTaskConfig(String closeActionID, Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fcs_taskconfig");
        if (customParam != null && !customParam.isEmpty()) {
            parameter.setCustomParam("initdata", customParam);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        this.getView().showForm(parameter);
    }

    private Map<String, Object> getCurrentTask(int rowIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("index", rowIndex);
        DynamicObject appid = (DynamicObject)this.getModel().getValue("appid", rowIndex);
        DynamicObject entity = (DynamicObject)this.getModel().getValue("mainentity", rowIndex);
        map.put("appid", EmptyUtil.isNoEmpty((DynamicObject)appid) ? appid.getString("id") : null);
        map.put("mainentity", EmptyUtil.isNoEmpty((DynamicObject)entity) ? entity.getString("id") : null);
        map.put("operatekey", this.getModel().getValue("operatekey", rowIndex));
        map.put("operatename", this.getModel().getValue("operatename", rowIndex));
        map.put("microservice", this.getModel().getValue("microservice", rowIndex));
        map.put("mserviceconfig_tag", this.getModel().getValue("mserviceconfig_tag", rowIndex));
        map.put("taskname", this.getModel().getValue("taskname", rowIndex));
        map.put("iscycle", this.getModel().getValue("iscycle", rowIndex));
        return map;
    }

    private void setTask(Map<String, Object> returnMap, int index) {
        this.getModel().setValue("taskname", returnMap.get("taskname"), index);
        this.getModel().setValue("operatename", returnMap.get("operatename"), index);
        this.getModel().setValue("operatekey", returnMap.get("operatekey"), index);
        this.getModel().setValue("mainentity", returnMap.get("mainentity"), index);
        this.getModel().setValue("appid", returnMap.get("appid"), index);
        this.getModel().setValue("microservice", returnMap.get("microservice"), index);
        this.getModel().setValue("mserviceconfig_tag", returnMap.get("mserviceconfig_tag"), index);
        this.getModel().setValue("iscycle", returnMap.get("iscycle"), index);
    }
}

