/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.common.enums.FinanceLeaseTypeEnum;

public class PayPlanUpdateHelper {
    public static void updateContractRentPayPlan(DynamicObject[] rentPayBills, String executeStatus) {
        Map<Object, DynamicObject> contractMap = PayPlanUpdateHelper.loadContracts(rentPayBills);
        ArrayList<DynamicObject> writeBackContracts = new ArrayList<DynamicObject>();
        for (DynamicObject rentPayBill : rentPayBills) {
            DynamicObject contract = contractMap.get(rentPayBill.getDynamicObject("loancontractbill").getPkValue());
            if (!EmptyUtil.isNoEmpty((DynamicObject)contract)) continue;
            PayPlanUpdateHelper.writeBackPlan(rentPayBill, contract, executeStatus);
            writeBackContracts.add(contract);
        }
        if (EmptyUtil.isNoEmpty(writeBackContracts)) {
            TmcDataServiceHelper.save((DynamicObject[])writeBackContracts.toArray(new DynamicObject[0]));
        }
    }

    public static void updateReceiptPayPlan(DynamicObject[] rentPayBills, String executeStatus) {
        ArrayList receiptBillIds = new ArrayList();
        for (DynamicObject rentPayBill : rentPayBills) {
            DynamicObjectCollection entry = rentPayBill.getDynamicObjectCollection("loans");
            receiptBillIds.addAll(entry.stream().map(v -> v.getDynamicObject("e_loanbill").getPkValue()).collect(Collectors.toList()));
        }
        String queryFields = "id,repayplan_entry,exrepaymentdate,repaystate,interest_entry,interesdate,intstate";
        Object[] receiptBills = TmcDataServiceHelper.load((String)"fl_receiptbill", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("id", "in", receiptBillIds)});
        Map dataMap = Arrays.stream(receiptBills).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (DynamicObject rentPayBill : rentPayBills) {
            Date payDate = rentPayBill.getDate("bizdate");
            DynamicObjectCollection loans = rentPayBill.getDynamicObjectCollection("loans");
            loans.stream().map(v -> (DynamicObject)dataMap.get(v.getDynamicObject("e_loanbill").getPkValue())).filter(EmptyUtil::isNoEmpty).forEach(r -> PayPlanUpdateHelper.writeBackReceipt(payDate, r, executeStatus));
        }
        if (EmptyUtil.isNoEmpty((Object[])receiptBills)) {
            SaveServiceHelper.update((DynamicObject[])receiptBills);
        }
    }

    private static void writeBackReceipt(Date payDate, DynamicObject receiptBill, String executeStatus) {
        DynamicObjectCollection rePayPlans = receiptBill.getDynamicObjectCollection("repayplan_entry");
        for (DynamicObject rePayPlan : rePayPlans) {
            if (rePayPlan.getDate("exrepaymentdate").compareTo(payDate) != 0) continue;
            rePayPlan.set("repaystate", (Object)executeStatus);
            break;
        }
        DynamicObjectCollection instPlans = receiptBill.getDynamicObjectCollection("interest_entry");
        for (DynamicObject instPlan : instPlans) {
            if (instPlan.getDate("interesdate").compareTo(payDate) != 0) continue;
            instPlan.set("intstate", (Object)executeStatus);
            break;
        }
    }

    public static Map<Object, DynamicObject> loadContracts(DynamicObject[] rentPayBills) {
        Object[] contractBillIds = Arrays.stream(rentPayBills).map(v -> v.getDynamicObject("loancontractbill")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
        String queryFields = "startrevdate,endrevdate,startinterestrate,amount,intamt,payacct,principal,notes,contractstatus,paydate,payedrent,unpayedrent,totalamt,entry_rentplan,paydate,rentamt,executestatus";
        DynamicObject[] contracts = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)contractBillIds)});
        return Arrays.stream(contracts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    public static boolean isFinLeaseTypeContract(Object contractId) {
        DynamicObject contract = TmcDataServiceHelper.loadSingle((String)"fl_leasecontractbill", (String)"finproduct", (QFilter[])new QFilter("ID", "=", contractId).toArray());
        DynamicObject finProduct = contract.getDynamicObject("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            return false;
        }
        String finLeaseType = finProduct.getString("financeleasetype");
        return FinanceLeaseTypeEnum.isFinanceLease((String)finLeaseType);
    }

    public static List<DynamicObject> updateReceiptPlan(DynamicObject contractBill, DynamicObject receiptBill) {
        DynamicObjectCollection plans = contractBill.getDynamicObjectCollection("entry_rentplan");
        List planList = plans.stream().filter(r -> ExecuteStatusEnum.isUnExecuted((String)r.getString("executestatus"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(planList)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> receiptList = PayPlanUpdateHelper.loadReceipts(contractBill, receiptBill);
        if (null != receiptBill) {
            receiptList.add(receiptBill);
            if (receiptBill.getBoolean("isinit")) {
                planList = new ArrayList(plans);
            }
        }
        receiptList.forEach(v -> v.getDynamicObjectCollection("repayplan_entry").removeIf(r -> StringUtils.equals((CharSequence)r.getString("repaystate"), (CharSequence)"0")));
        receiptList.forEach(v -> v.getDynamicObjectCollection("interest_entry").removeIf(r -> StringUtils.equals((CharSequence)r.getString("intstate"), (CharSequence)"0")));
        receiptList.sort(Comparator.comparing(r -> r.getDate("createtime")));
        BigDecimal amount = contractBill.getBigDecimal("amount");
        BigDecimal startInstRate = contractBill.getBigDecimal("startinterestrate");
        boolean isSettled = StringUtils.equals((CharSequence)contractBill.getString("contractstatus"), (CharSequence)"D");
        for (DynamicObject plan : planList) {
            PayPlanUpdateHelper.genRePayPlan(plan, receiptList, amount, isSettled);
            if (startInstRate.compareTo(BigDecimal.ZERO) == 0) continue;
            PayPlanUpdateHelper.genInstPlan(plan, receiptList, amount, isSettled);
        }
        return receiptList;
    }

    private static void genRePayPlan(DynamicObject plan, List<DynamicObject> receiptList, BigDecimal amount, boolean isSettled) {
        BigDecimal principal;
        BigDecimal residueAmt = principal = plan.getBigDecimal("principal");
        int len = receiptList.size();
        for (int index = 0; index < len; ++index) {
            DynamicObject receipt = receiptList.get(index);
            BigDecimal ratio = receipt.getBigDecimal("drawamount").divide(amount, RoundingMode.HALF_UP);
            DynamicObject addNew = receipt.getDynamicObjectCollection("repayplan_entry").addNew();
            BigDecimal payAmt = index == len - 1 && isSettled ? residueAmt : principal.multiply(ratio);
            payAmt = payAmt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : payAmt;
            addNew.set("exrepaymentdate", (Object)plan.getDate("paydate"));
            addNew.set("exdrawamount", (Object)payAmt);
            addNew.set("erepayamount", (Object)BigDecimal.ZERO);
            addNew.set("enotrepayamount", (Object)payAmt);
            addNew.set("repaystate", (Object)"0");
            addNew.set("repayaccount", (Object)plan.getDynamicObject("payacct"));
            addNew.set("repaymentdesc", (Object)plan.getString("notes"));
            residueAmt = residueAmt.subtract(payAmt);
        }
    }

    private static void genInstPlan(DynamicObject plan, List<DynamicObject> receiptList, BigDecimal amount, boolean isSettled) {
        BigDecimal intAmt;
        BigDecimal residueAmt = intAmt = plan.getBigDecimal("intamt");
        int len = receiptList.size();
        for (int index = 0; index < len; ++index) {
            DynamicObject receipt = receiptList.get(index);
            BigDecimal ratio = receipt.getBigDecimal("drawamount").divide(amount, RoundingMode.HALF_UP);
            DynamicObjectCollection entry = receipt.getDynamicObjectCollection("interest_entry");
            DynamicObject addNew = entry.addNew();
            BigDecimal payInstAmt = index == len - 1 && isSettled ? residueAmt : intAmt.multiply(ratio);
            payInstAmt = payInstAmt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : payInstAmt;
            addNew.set("intway", (Object)"payprinandinte");
            addNew.set("interestseq", (Object)entry.size());
            addNew.set("intstartdate", (Object)plan.getDate("startrevdate"));
            addNew.set("intenddate", (Object)plan.getDate("endrevdate"));
            addNew.set("interesdate", (Object)plan.getDate("paydate"));
            addNew.set("interestcalamount", (Object)payInstAmt);
            addNew.set("intstate", (Object)"0");
            addNew.set("instdescription", (Object)plan.getString("notes"));
            addNew.set("intaccount", (Object)plan.getDynamicObject("payacct"));
            residueAmt = residueAmt.subtract(payInstAmt);
        }
    }

    public static boolean isNotBetweenDate(DynamicObject leaseContract, Date date) {
        if (null != date) {
            Date startDate = leaseContract.getDate("startdate");
            Date endDate = leaseContract.getDate("enddate");
            return startDate.compareTo(date) > 0 || endDate.compareTo(date) < 0;
        }
        return true;
    }

    private static List<DynamicObject> loadReceipts(DynamicObject contractBill, DynamicObject receiptBill) {
        String queryFields = "bizdate,interest_entry,createtime,repayplan_entry,drawamount,exrepaymentdate,exdrawamount,erepayamount,enotrepayamount,isinit,repaystate,repaymentdesc,repayaccount,intway,interestseq,intstartdate,intenddate,interesdate,interestcalamount,intstate,instdescription,intaccount";
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        if (null != receiptBill) {
            qFilter.and("id", "!=", receiptBill.getPkValue());
        }
        return Arrays.stream(TmcDataServiceHelper.load((String)"fl_receiptbill", (String)queryFields, (QFilter[])new QFilter[]{qFilter})).collect(Collectors.toList());
    }

    private static void writeBackPlan(DynamicObject rentPayBill, DynamicObject contract, String executeStatus) {
        Date payDate = rentPayBill.getDate("bizdate");
        DynamicObjectCollection rentPlans = contract.getDynamicObjectCollection("entry_rentplan");
        for (DynamicObject rentPlan : rentPlans) {
            if (payDate.compareTo(rentPlan.getDate("paydate")) != 0 || rentPayBill.getBigDecimal("amount").compareTo(rentPlan.getBigDecimal("principal")) != 0) continue;
            rentPlan.set("executestatus", (Object)executeStatus);
            break;
        }
        BigDecimal payedRent = rentPlans.stream().filter(v -> ExecuteStatusEnum.isExecuted((String)v.getString("executestatus"))).map(r -> r.getBigDecimal("rentamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        contract.set("payedrent", (Object)payedRent);
        BigDecimal unPayedRent = rentPlans.stream().filter(v -> ExecuteStatusEnum.isUnExecuted((String)v.getString("executestatus"))).map(r -> r.getBigDecimal("rentamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        contract.set("unpayedrent", (Object)unPayedRent);
    }
}

