/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.contract;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class LeaseContractBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry_rentplan");
        selector.add("amount");
        selector.add("rentamt");
        selector.add("totalamt");
        selector.add("payedrent");
        selector.add("unpayedrent");
        selector.add("executestatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject contract : dataEntities) {
            DynamicObjectCollection rentPlans = contract.getDynamicObjectCollection("entry_rentplan");
            BigDecimal totalAmt = contract.getBigDecimal("amount");
            BigDecimal payedRent = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rentPlans)) {
                BigDecimal rentAmt = rentPlans.stream().map(r -> r.getBigDecimal("rentamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalAmt = EmptyUtil.isNoEmpty((BigDecimal)rentAmt) ? rentAmt : totalAmt;
                payedRent = rentPlans.stream().filter(v -> ExecuteStatusEnum.isExecuted((String)v.getString("executestatus"))).map(r -> r.getBigDecimal("rentamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            contract.set("totalamt", (Object)totalAmt);
            contract.set("unpayedrent", (Object)totalAmt.subtract(payedRent));
            contract.set("payedrent", (Object)payedRent);
        }
    }
}

