/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LeaseContractBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("ID");
        sic.add("isinit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] submitBills;
        List ids = Arrays.stream(dataEntities).filter(dyn -> !dyn.getBoolean("isinit")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(ids)) {
            return;
        }
        DynamicObjectCollection receiptBills = QueryServiceHelper.query((String)"fl_receiptbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", ids)});
        Object[] receiptIds = receiptBills.stream().map(v -> v.get("id")).toArray();
        Object[] auditBills = receiptBills.stream().filter(v -> BillStatusEnum.isAudit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])auditBills)) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"fl_receiptbill", (Object[])auditBills, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])(submitBills = receiptBills.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray()))) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"fl_receiptbill", (Object[])submitBills, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])receiptIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"fl_receiptbill", (Object[])receiptIds, (OperateOption)OperateOption.create());
        }
    }
}

