/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.contract.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class LeaseContractInitAuditSyncRentPayService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LeaseContractInitAuditSyncRentPayService.class);
    private static final String[] DRAW_PROPS = new String[]{"id", "creditlimit", "billno", "repayplan_entry.id", "interest_entry.id", "interest_entry.interest_subentry.id"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("entry_rentplan");
        sic.add("paydate");
        sic.add("startrevdate");
        sic.add("endrevdate");
        sic.add("rentamt");
        sic.add("principal");
        sic.add("intamt");
        sic.add("executestatus");
        sic.add("isinitplan");
        sic.add("billno");
        sic.add("startinterestrate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        try {
            for (DynamicObject contract : dataEntities) {
                DynamicObject[] receiptBills = TmcDataServiceHelper.load((String)"fl_receiptbill", (String)String.join((CharSequence)",", DRAW_PROPS), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", contract.getPkValue())});
                this.handleSyncRentPay(contract, receiptBills[0]);
                TmcAttachmentHelper.setAttachments((DynamicObject)contract, (String)"fl_leasecontractbill", (Long)contract.getLong("ID"), (String)"attachmentpanel", (String)"attachmentpanel");
            }
        }
        catch (Exception e) {
            logger.error(FlBusinessResourceEnum.LeaseContractInitAuditSyncRentPayService_0.loadKDString(), (Throwable)e);
            throw e;
        }
    }

    private void handleSyncRentPay(DynamicObject contract, DynamicObject receipt) {
        block6: {
            DynamicObject[] rentpayTemp = TmcBotpHelper.push((DynamicObject)receipt, (String)"fl_rentpaybill");
            DynamicObjectCollection rentPlans = contract.getDynamicObjectCollection("entry_rentplan");
            Boolean isZeroRate = contract.getBigDecimal("startinterestrate").compareTo(BigDecimal.ZERO) == 0;
            ArrayList<DynamicObject> rentpays = new ArrayList<DynamicObject>(rentPlans.size());
            for (int i = 0; i < rentPlans.size(); ++i) {
                DynamicObject rentPlan = (DynamicObject)rentPlans.get(i);
                if (ExecuteStatusEnum.isUnExecuted((String)rentPlan.getString("executestatus"))) continue;
                DynamicObject rentpay = TmcDataServiceHelper.clone((DynamicObject)rentpayTemp[0]);
                rentpay.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"fl_rentpaybill", (DynamicObject)rentpay, (String)rentpay.getDynamicObject("org").getString("id")));
                rentpay.set("bizdate", (Object)rentPlan.getDate("paydate"));
                rentpay.set("totalamt", (Object)rentPlan.getBigDecimal("rentamt"));
                rentpay.set("amount", (Object)rentPlan.getBigDecimal("principal"));
                rentpay.set("instamt", (Object)rentPlan.getBigDecimal("intamt"));
                LeaseContractInitAuditSyncRentPayService.setTargetLoansEntry(rentPlan, rentpay, isZeroRate);
                rentpay.set("isinit", (Object)"1");
                rentpays.add(rentpay);
            }
            if (EmptyUtil.isEmpty(rentpays)) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "TRUE");
            option.setVariableValue("byInit", "true");
            OperationResult submitResult = null;
            try {
                submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"fl_rentpaybill", (DynamicObject[])rentpays.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!EmptyUtil.isEmpty((Collection)submitResult.getSuccessPkIds())) {
                    Object[] loanBillIds = submitResult.getSuccessPkIds().toArray();
                    OperationResult auditResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"fl_rentpaybill", (Object[])loanBillIds, (OperateOption)option);
                    if (EmptyUtil.isEmpty((Collection)auditResult.getSuccessPkIds())) {
                        throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)auditResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
                    }
                    break block6;
                }
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)submitResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            catch (Exception e) {
                logger.error(FlBusinessResourceEnum.LeaseContractInitAuditSyncRentPayService_1.loadKDString(), (Throwable)e);
                throw e;
            }
        }
    }

    public void afterProcessRollback(DynamicObject[] dataEntities) throws KDException {
        Object[] submitBills;
        Set contractNos = Arrays.stream(dataEntities).map(dny -> dny.getLong("ID")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("loancontractbill", "in", contractNos);
        DynamicObjectCollection rentPays = QueryServiceHelper.query((String)"fl_rentpaybill", (String)"id,billstatus", (QFilter[])qFilter.toArray());
        Object[] rentPayIds = rentPays.stream().map(v -> v.get("id")).toArray();
        Object[] auditBills = rentPays.stream().filter(v -> BillStatusEnum.isAudit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])auditBills)) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"fl_rentpaybill", (Object[])auditBills, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])(submitBills = rentPays.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray()))) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"fl_rentpaybill", (Object[])submitBills, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])rentPayIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"fl_rentpaybill", (Object[])rentPayIds, (OperateOption)OperateOption.create());
        }
    }

    private static void setTargetLoansEntry(DynamicObject rentPlan, DynamicObject rentpay, Boolean isZeroRate) {
        DynamicObject entryCol = (DynamicObject)rentpay.getDynamicObjectCollection("loans").get(0);
        entryCol.set("e_repayamount", (Object)rentPlan.getBigDecimal("principal"));
        entryCol.set("e_convertrepayamt", (Object)rentPlan.getBigDecimal("principal"));
        entryCol.set("e_actintamt", (Object)rentPlan.getBigDecimal("intamt"));
        if (isZeroRate.booleanValue()) {
            entryCol.set("e_ispayinst", (Object)"0");
        }
    }
}

