/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.feeshare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fl.common.bean.LeaseShareInfo;
import kd.tmc.fl.common.helper.LeaseFeeHelper;
import kd.tmc.fl.common.helper.LeaseFeeShareHelper;

public class LeaseFeeShareCalculateService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        Set sbillID = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("conbillno").getLong("id")).collect(Collectors.toSet());
        DynamicObject[] loands = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)"id,feedetail.feeamt,bizdate,org,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", sbillID)});
        Map<Object, DynamicObject> loandMap = Arrays.stream(loands).collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (DynamicObject bill : dataEntities) {
            Long conId = bill.getDynamicObject("conbillno").getLong("id");
            DynamicObject contractBill = loandMap.get(conId);
            Date endDate = bill.getDate("expiredate");
            Map feeAmountMap = LeaseFeeHelper.getFeeAmountMap((long)conId, (Date)endDate, (long)contractBill.getDynamicObject("currency").getLong("id"), (long)contractBill.getDynamicObject("org").getLong("id"));
            BigDecimal feeAmount = feeAmountMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal payPlanAmount = LeaseFeeHelper.getPayPlanAmount((long)conId);
            bill.set("feeamount", (Object)feeAmount.add(payPlanAmount));
            List leaseShareDetails = LeaseFeeShareHelper.getLeaseShareDetails((DynamicObject)bill, (Map)feeAmountMap);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            entrys.clear();
            BigDecimal ytm = BigDecimal.ZERO;
            for (LeaseShareInfo info : leaseShareDetails) {
                ytm = info.getYtm();
                DynamicObject entry = entrys.addNew();
                entry.set("e_period", (Object)(DateUtils.formatString((Date)info.getStartDate(), (String)"yyyy-MM-dd") + "-" + DateUtils.formatString((Date)info.getEndDate(), (String)"yyyy-MM-dd")));
                entry.set("e_startdate", (Object)info.getStartDate());
                entry.set("e_enddate", (Object)info.getEndDate());
                entry.set("e_day", (Object)info.getDays());
                entry.set("e_begincostamt", (Object)info.getBegincostamt());
                entry.set("e_curfeeamt", (Object)info.getCurfeeamt());
                entry.set("e_curguaamt", (Object)info.getCurguaamt());
                entry.set("e_currepurchaseamt", (Object)info.getCurrepurchaseamt());
                entry.set("e_rentamt", (Object)info.getRentamt());
                entry.set("e_principal", (Object)info.getPrincipal());
                entry.set("e_intamt", (Object)info.getIntamt());
                entry.set("e_accrualinterest", (Object)info.getAccrualinterest());
                entry.set("e_repayamt", (Object)info.getRepayamt());
                entry.set("e_actualamount", (Object)info.getAccrualinterest());
                entry.set("e_endcostamt", (Object)info.getEndcostamt());
                entry.set("e_guaincomeamt", (Object)info.getGuaincomeamt());
                entry.set("e_guabalanceamt", (Object)info.getGuabalanceamt());
                entry.set("e_isvoucher", (Object)info.isVoucher());
                entry.set("e_islock", (Object)info.isLock());
            }
            ytm = ytm.multiply(Constants.ONE_HUNDRED);
            bill.set("irr", (Object)ytm);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

