/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.rentplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class RentPlanPushRentPayService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry_rentplan");
        selector.add("rentamt");
        selector.add("principal");
        selector.add("intamt");
        selector.add("paydate");
        selector.add("payacct");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map opMap = this.getOperationVariable();
        String targetBillStatus = BillStatusEnum.SAVE.getValue();
        String billstatusParam = (String)opMap.get("billstatus_param");
        if (EmptyUtil.isNoEmpty((String)billstatusParam)) {
            targetBillStatus = billstatusParam;
        }
        List contractIds = Arrays.stream(dataEntities).map(r -> r.getPkValue()).collect(Collectors.toList());
        QFilter loanFilter = new QFilter("sourcebillid", "in", contractIds);
        loanFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection loanCols = QueryServiceHelper.query((String)"fl_receiptbill", (String)"sourcebillid,id", (QFilter[])new QFilter[]{loanFilter}, (String)"");
        Map contractMap = loanCols.stream().collect(Collectors.groupingBy(r -> r.getLong("sourcebillid"), Collectors.mapping(r -> r.getLong("id"), Collectors.toList())));
        for (DynamicObject rentPlan : dataEntities) {
            List<Long> loanBills = contractMap.get(rentPlan.getLong("ID"));
            DynamicObjectCollection planCols = rentPlan.getDynamicObjectCollection("entry_rentplan");
            Optional<DynamicObject> firstOp = planCols.stream().filter(r -> ExecuteStatusEnum.isUnExecuted((String)r.getString("executestatus"))).filter(r -> r.getDate("paydate").compareTo(DateUtils.getCurrentDate()) <= 0).sorted(Comparator.comparing(r -> r.getDate("paydate"))).findFirst();
            if (!firstOp.isPresent()) continue;
            this.pushRentPayBill(rentPlan, firstOp.get(), loanBills, targetBillStatus);
        }
    }

    private void pushRentPayBill(DynamicObject rentPlan, DynamicObject row, List<Long> loanBills, String targetBillStatus) {
        OperateOption option = OperateOption.create();
        Object[] targetBills = TmcBotpHelper.batchPush((Object[])loanBills.toArray(), (String)"fl_receiptbill", (String)"fl_rentpaybill");
        if (EmptyUtil.isEmpty((Object[])targetBills) || targetBills.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u6b3e\u5355\u591a\u5bf9\u4e00\u4e0b\u63a8\u79df\u91d1\u652f\u4ed8\u5355\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"RentPlanPushRentPayService_1", (String)"tmc-fl-business", (Object[])new Object[0]));
        }
        for (Object targetBill : targetBills) {
            targetBill.set("bizdate", (Object)row.getDate("paydate"));
            targetBill.set("totalamt", (Object)row.getBigDecimal("rentamt"));
            targetBill.set("amount", (Object)row.getBigDecimal("principal"));
            targetBill.set("instamt", (Object)row.getBigDecimal("intamt"));
            targetBill.set("accountbank", row.get("payacct"));
            this.shareAmtInPro((DynamicObject)targetBill, "amount", "e_repayamount");
            this.shareAmtInPro((DynamicObject)targetBill, "amount", "e_convertrepayamt");
            this.setInstCalc((DynamicObject)targetBill);
            this.shareAmtInPro((DynamicObject)targetBill, "instamt", "e_actintamt");
        }
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"save", (String)"fl_rentpaybill", (DynamicObject[])targetBills, (OperateOption)option);
        if (EmptyUtil.isEmpty((Object)result) || !result.isSuccess()) {
            return;
        }
        if (BillStatusEnum.isSave((String)targetBillStatus)) {
            return;
        }
        QFilter qFilter = new QFilter("loancontractbill", "=", rentPlan.getPkValue());
        qFilter.and(new QFilter("bizdate", "=", (Object)row.getDate("paydate")));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        List targetIds = QueryServiceHelper.queryPrimaryKeys((String)"fl_rentpaybill", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc", (int)1);
        if (EmptyUtil.isEmpty((Collection)targetIds)) {
            return;
        }
        option.setVariableValue("WF", "TRUE");
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"fl_rentpaybill", (Object[])targetIds.toArray(), (OperateOption)option);
        if (EmptyUtil.isEmpty((Object)submitResult) || !submitResult.isSuccess()) {
            return;
        }
        if (BillStatusEnum.isAudit((String)targetBillStatus)) {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"fl_rentpaybill", (Object[])targetIds.toArray(), (OperateOption)option);
        }
    }

    private void shareAmtInPro(DynamicObject repayBill, String amountField, String shareField) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        BigDecimal rePayAbleAmt = loans.stream().map(v -> v.getBigDecimal("e_repayableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmt = repayBill.getBigDecimal(amountField);
        int rowCount = loans.size();
        BigDecimal sharedAmt = BigDecimal.ZERO;
        int scale = Optional.ofNullable(repayBill.getDynamicObject("currency")).map(r -> r.getInt("amtprecision")).orElse(2);
        for (int rowIndex = 0; rowIndex < rowCount - 1; ++rowIndex) {
            DynamicObject row = (DynamicObject)loans.get(rowIndex);
            BigDecimal payAmt = row.getBigDecimal("e_repayableamount");
            BigDecimal shareAmt = payAmt.multiply(totalAmt).divide(rePayAbleAmt, scale, RoundingMode.HALF_UP);
            row.set(shareField, (Object)shareAmt);
            sharedAmt = sharedAmt.add(shareAmt);
        }
        ((DynamicObject)loans.get(rowCount - 1)).set(shareField, (Object)totalAmt.subtract(sharedAmt));
    }

    private void setInstCalc(DynamicObject repayBill) {
        DynamicObject contractBill = repayBill.getDynamicObject("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        DynamicObject contract = QueryServiceHelper.queryOne((String)"fl_leasecontractbill", (String)"startinterestrate", (QFilter[])new QFilter("ID", "=", contractBill.getPkValue()).toArray());
        BigDecimal startInstRate = contract.getBigDecimal("startinterestrate");
        String isPayInst = EmptyUtil.isEmpty((BigDecimal)startInstRate) ? "0" : "1";
        DynamicObjectCollection loanCols = repayBill.getDynamicObjectCollection("loans");
        for (int i = 0; i < loanCols.size(); ++i) {
            DynamicObject row = (DynamicObject)loanCols.get(i);
            row.set("e_ispayinst", (Object)isPayInst);
            row.set("e_combineinst", (Object)isPayInst);
        }
    }
}

