/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.contractbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class LeaseContractSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("repurchaseamt");
        selector.add("entry_rentplan");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("paydate");
        selector.add("startrevdate");
        selector.add("endrevdate");
        selector.add("startinterestrate");
        selector.add("intamt");
        selector.add("guarantee");
        selector.add("isinit");
        selector.add("entry_gcontract");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateGuaranteeWay(extendedDataEntity);
            this.validateAmt(extendedDataEntity);
        }
    }

    private void validateGuaranteeWay(ExtendedDataEntity extendedDataEntity) {
        DynamicObject leaseContract = extendedDataEntity.getDataEntity();
        String guaranteeWay = leaseContract.getString("guarantee");
        List guaWayList = Arrays.stream(guaranteeWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        if (guaWayList.contains(GuaranteeWayEnum.NONE.getNumberValue()) && guaWayList.size() > 1) {
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.GuaranteeWayValidator_0.loadKDString());
        }
        boolean relateDebt = this.isRelateDebt(leaseContract);
        if (guaWayList.contains(GuaranteeWayEnum.ENSURE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.MORTGAGE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.PLEDGE.getNumberValue())) {
            DynamicObjectCollection gcUseEntry = leaseContract.getDynamicObjectCollection("entry_gcontract");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gcUseEntry)) {
                gcUseEntry = this.getGuaranteeUseFromDb(leaseContract.getLong("ID"));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gcUseEntry) && relateDebt && leaseContract.getBoolean("isinit")) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.GuaranteeWayValidator_1.loadKDString());
            }
        }
    }

    private DynamicObjectCollection getGuaranteeUseFromDb(Long leaseContractId) {
        if (EmptyUtil.isEmpty((Long)leaseContractId)) {
            return new DynamicObjectCollection();
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", (Object)leaseContractId);
        return QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "gsrcbillid", "gratio"), (QFilter[])new QFilter[]{idFilter});
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        DynamicObject mainBizOrg = bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg());
        if (EmptyUtil.isEmpty((DynamicObject)mainBizOrg)) {
            return false;
        }
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)mainBizOrg.getLong("id"), (String)"isrelatedebt");
    }

    private void validateAmt(ExtendedDataEntity extendedDataEntity) {
        DynamicObject leaseContract = extendedDataEntity.getDataEntity();
        BigDecimal amount = leaseContract.getBigDecimal("amount");
        BigDecimal rePurchaseAmt = leaseContract.getBigDecimal("repurchaseamt");
        if (rePurchaseAmt.compareTo(amount) > 0) {
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.LeaseContractSubmitValidator_1.loadKDString());
        }
    }
}

