/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.rentpay;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fl.business.helper.PayPlanUpdateHelper;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class RentPayBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("amount");
        selector.add("loancontractbill");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DynamicObject[] rentPays = (DynamicObject[])Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        Map<Object, DynamicObject> contractBillMap = PayPlanUpdateHelper.loadContracts(rentPays);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject rentPay = extendedDataEntity.getDataEntity();
            Date payDate = rentPay.getDate("bizdate");
            BigDecimal amount = rentPay.getBigDecimal("amount");
            DynamicObject contractBill = contractBillMap.get(rentPay.getDynamicObject("loancontractbill").getPkValue());
            DynamicObjectCollection rentPlans = contractBill.getDynamicObjectCollection("entry_rentplan");
            boolean noneMatch = rentPlans.stream().filter(r -> ExecuteStatusEnum.isUnExecuted((String)r.getString("executestatus"))).noneMatch(v -> v.getDate("paydate").compareTo(payDate) == 0 && v.getBigDecimal("principal").compareTo(amount) == 0);
            if (!noneMatch || rentPay.getBoolean("isinit")) continue;
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.RentPayBillAuditValidator_0.loadKDString());
        }
    }
}

