/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.rentpay;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class RentPayBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("loans");
        selector.add("e_repayamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObjectCollection loans;
            BigDecimal repaymentAmt;
            DynamicObject rentPayBill = extendedDataEntity.getDataEntity();
            BigDecimal amount = rentPayBill.getBigDecimal("amount");
            if (amount.compareTo(repaymentAmt = (loans = rentPayBill.getDynamicObjectCollection("loans")).stream().map(v -> v.getBigDecimal("e_repayamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.RentPayBillSubmitValidator_0.loadKDString());
        }
    }
}

