/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.rentplan;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.enums.ApplyBizStatusEnum;
import kd.tmc.fl.common.enums.ConfirmStatusEnum;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class RentPlanPushRentPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("entry_rentplan");
        selector.add("paydate");
        selector.add("executestatus");
        selector.add("currency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObjectCollection planCols;
            List rowList;
            DynamicObject rentPlan = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)rentPlan.getString("billstatus"))) {
                this.addErrorMessage(extData, FlBusinessResourceEnum.RentPlanPushRentPayValidator_1.loadKDString());
            }
            if (EmptyUtil.isEmpty(rowList = (planCols = rentPlan.getDynamicObjectCollection("entry_rentplan")).stream().filter(r -> ExecuteStatusEnum.isUnExecuted((String)r.getString("executestatus"))).filter(r -> EmptyUtil.isNoEmpty((Object)r.getDate("paydate")) && r.getDate("paydate").compareTo(DateUtils.getCurrentDate()) <= 0).collect(Collectors.toList()))) {
                this.addErrorMessage(extData, FlBusinessResourceEnum.RentPlanPushRentPayValidator_2.loadKDString());
            }
            this.validateExistsDoing(extData, rentPlan);
            this.validateDifCurrency(extData, rentPlan);
            this.validateOnModifying(extData, rentPlan);
        }
    }

    private void validateDifCurrency(ExtendedDataEntity extData, DynamicObject rentPlan) {
        QFilter qFilter = new QFilter("loancontractbill", "=", rentPlan.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObject currency = rentPlan.getDynamicObject("currency");
        qFilter.and(new QFilter("currency", "!=", currency.getPkValue()));
        boolean exists = TmcDataServiceHelper.exists((String)"fl_receiptbill", (QFilter[])qFilter.toArray());
        if (exists) {
            this.addErrorMessage(extData, FlBusinessResourceEnum.RentPlanPushRentPayValidator_3.loadKDString());
        }
    }

    private void validateOnModifying(ExtendedDataEntity extData, DynamicObject rentPlan) {
        QFilter qFilter = new QFilter("loancontractbill", "=", rentPlan.getPkValue());
        qFilter.and("bizstatus", "in", (Object)new String[]{ApplyBizStatusEnum.APPLYING.getValue(), ApplyBizStatusEnum.HANDING.getValue()});
        boolean exists = QueryServiceHelper.exists((String)"fl_contract_apply", (QFilter[])qFilter.toArray());
        if (exists) {
            this.addErrorMessage(extData, FlBusinessResourceEnum.RentPlanPushRentPayValidator_4.loadKDString());
        }
    }

    private void validateExistsDoing(ExtendedDataEntity extData, DynamicObject rentPlan) {
        QFilter repayFilter = new QFilter("loancontractbill", "=", rentPlan.getPkValue()).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        boolean isHasIngRepayBill = TmcDataServiceHelper.exists((String)"fl_rentpaybill", (QFilter[])repayFilter.toArray());
        if (isHasIngRepayBill) {
            this.addErrorMessage(extData, FlBusinessResourceEnum.RentPlanPushRentPayValidator_5.loadKDString());
        }
    }
}

