/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.transform;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fl.business.helper.ContractTransformHelper;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class ContractTransformSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loancontractbill");
        selector.add("entry_rentplan");
        selector.add("paydate");
        selector.add("startrevdate");
        selector.add("endrevdate");
        selector.add("rentamt");
        selector.add("principal");
        selector.add("intamt");
        selector.add("taxrate");
        selector.add("taxamt");
        selector.add("excludetaxamt");
        selector.add("residueamt");
        selector.add("payacct");
        selector.add("notes");
        selector.add("leaseholdtype");
        selector.add("leaseholdtypeid");
        selector.add("leasehold");
        selector.add("leaseholdid");
        selector.add("repurchaseamt");
        selector.add("assetcount");
        selector.add("unit");
        selector.add("repurchase");
        selector.add("address");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<DynamicObject> contractTransforms = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map<Object, DynamicObject> contractDataMap = ContractTransformHelper.loadContractDataMap(contractTransforms);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            BigDecimal amount;
            DynamicObjectCollection rentPlan;
            BigDecimal principal;
            DynamicObject contractTransform = extendedDataEntity.getDataEntity();
            Object loanContractId = contractTransform.getDynamicObject("loancontractbill").getPkValue();
            DynamicObject contractBill = contractDataMap.get(loanContractId);
            if (null == contractBill) continue;
            if (ContractTransformHelper.checkLeashHoldChange(contractTransform, contractBill)) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_1.loadKDString());
            }
            if ((principal = (rentPlan = contractTransform.getDynamicObjectCollection("entry_rentplan")).stream().map(o -> o.getBigDecimal("principal")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(amount = contractTransform.getBigDecimal("amount")) != 0) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_2.loadKDString());
            }
            for (int i = 1; i < rentPlan.size(); ++i) {
                Date lastEndRevDate = ((DynamicObject)rentPlan.get(i - 1)).getDate("endrevdate");
                Date startRevDate = ((DynamicObject)rentPlan.get(i)).getDate("startrevdate");
                if (null != startRevDate && null != lastEndRevDate && startRevDate.compareTo(lastEndRevDate) <= 0) {
                    this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_4.loadKDString(i + 1));
                }
                Date lastPayDate = ((DynamicObject)rentPlan.get(i - 1)).getDate("paydate");
                Date payDate = ((DynamicObject)rentPlan.get(i)).getDate("paydate");
                if (null == payDate || null == lastEndRevDate || payDate.compareTo(lastPayDate) > 0) continue;
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_5.loadKDString(i + 1));
            }
            long count = rentPlan.stream().map(o -> o.getDate("paydate")).distinct().count();
            if (count != (long)rentPlan.size()) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_3.loadKDString());
                return;
            }
            if (!ContractTransformHelper.checkPayPlanChange(contractTransform, contractBill)) continue;
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformSubmitValidator_0.loadKDString());
        }
    }
}

