/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.transform;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fl.business.helper.ContractTransformHelper;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class ContractTransformUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loancontractbill");
        selector.add("entry_rentplan");
        selector.add("paydate");
        selector.add("startrevdate");
        selector.add("rentamt");
        selector.add("endrevdate");
        selector.add("principal");
        selector.add("intamt");
        selector.add("taxrate");
        selector.add("taxamt");
        selector.add("excludetaxamt");
        selector.add("residueamt");
        selector.add("payacct");
        selector.add("notes");
        selector.add("leaseholdtypeid");
        selector.add("leaseholdtype");
        selector.add("leasehold");
        selector.add("leaseholdid");
        selector.add("repurchaseamt");
        selector.add("assetcount");
        selector.add("repurchase");
        selector.add("unit");
        selector.add("address");
        selector.add("executestatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<DynamicObject> contractTransforms = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map<Object, DynamicObject> contractDataMap = ContractTransformHelper.loadContractDataMap(contractTransforms);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject contractTransform = extendedDataEntity.getDataEntity();
            Object loanContractId = contractTransform.getDynamicObject("loancontractbill").getPkValue();
            DynamicObject contractBill = contractDataMap.get(loanContractId);
            if (null == contractBill) continue;
            if (ContractTransformHelper.checkPayPlanChange(contractTransform, contractBill)) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformUnAuditValidator_0.loadKDString());
            }
            if (!ContractTransformHelper.checkLeashHoldChange(contractTransform, contractBill)) continue;
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.ContractTransformUnAuditValidator_1.loadKDString());
        }
    }
}

