/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.contractbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.helper.PayPlanUpdateHelper;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.common.enums.FinanceLeaseTypeEnum;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class LeaseContractEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"leaseholdtype", "leasehold"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.orgChgEvt();
        this.finProductChgEvt(true);
        this.setDynamicField();
        this.isSyncDrawChgEvt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "finproduct": {
                this.finProductChgEvt(false);
                break;
            }
            case "org": {
                this.orgChgEvt();
                break;
            }
            case "leaseholdtype": {
                this.getModel().setValue("leasehold", (Object)"");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"leaseholdtypeid", (Object)0);
                break;
            }
            case "leasehold": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"leaseholdid", (Object)0);
                break;
            }
            case "amount": {
                this.amountChgEvt();
                break;
            }
            case "drawway": 
            case "issyncdraw": {
                this.isSyncDrawChgEvt();
                break;
            }
            case "enddate": 
            case "term": {
                this.endDateChgEvt();
                break;
            }
            case "endrevdate": {
                this.endRevDateChgEvt();
                break;
            }
            case "startdate": {
                this.startDateChgEvt();
                break;
            }
            case "startinterestrate": {
                boolean isNot0Rate;
                boolean bl = isNot0Rate = BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("startinterestrate")) != 0;
                if (isNot0Rate) break;
                this.getModel().setValue("floatingratio", null);
                this.getModel().setValue("overrate", null);
                break;
            }
            case "overratetype": {
                String overRateType = (String)e.getChangeSet()[0].getNewValue();
                if ("percent".equals(overRateType)) {
                    this.getModel().setValue("overrate", null);
                    break;
                }
                this.getModel().setValue("floatingratio", null);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"repurchaseamt")) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            String newVal = (String)e.getValue();
            if (EmptyUtil.isNoEmpty((String)newVal) && amount.compareTo(new BigDecimal(newVal)) < 0) {
                this.getView().showTipNotification(FlFormResourceEnum.LeaseContractEdit_0.loadKDString());
                e.setCancel(true);
                this.getView().updateView(e.getKey());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"leaseholdtype")) {
            this.showLeaseholdTypeList();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"leasehold")) {
            this.showLeaseholdList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        List<String> clickFields = Arrays.asList("leaseholdtype", "leasehold");
        if (EmptyUtil.isNoEmpty((Object)returnData) && clickFields.contains(actionId)) {
            ListSelectedRowCollection selected = (ListSelectedRowCollection)event.getReturnData();
            String selectName = selected.get(0).getName();
            Object selectId = selected.get(0).getPrimaryKeyValue();
            this.getModel().setValue(actionId, (Object)selectName);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)(actionId + "id"), (Object)selectId);
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)"leasehold")) {
                DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real_base", (String)"assetamount,unit", (QFilter[])new QFilter[]{new QFilter("id", "=", selectId)});
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"assetcount", (Object)realCard.get("assetamount"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)realCard.get("unit"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object contractId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushreceipt") && PayPlanUpdateHelper.isFinLeaseTypeContract((Object)(contractId = this.getModel().getDataEntity().getPkValue()))) {
            this.getView().showTipNotification(FlFormResourceEnum.LeaseContractList_0.loadKDString());
            args.setCancel(true);
        }
    }

    private void showLeaseholdTypeList() {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"fa_assetcategory", (boolean)false, (int)2, (boolean)true);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leaseholdtype"));
        showParam.setSelectedRow(this.getModel().getValue("leaseholdtypeid"));
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)"1");
        showParam.getListFilterParameter().getQFilters().add(filter);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        showParam.setUseOrgId(org.getLong("ID"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void showLeaseholdList() {
        DynamicObject org;
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"fa_card_real_base", (boolean)false, (int)2, (boolean)true);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leasehold"));
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Object leaseholdTypeId = this.getModel().getValue("leaseholdtypeid");
        if (EmptyUtil.isNoEmpty((Object)leaseholdTypeId)) {
            filter.and("assetcat", "=", leaseholdTypeId);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(org = (DynamicObject)this.getModel().getValue("org")))) {
            filter.and("org", "=", org.getPkValue());
        }
        showParam.getListFilterParameter().getQFilters().add(filter);
        showParam.setSelectedRow(this.getModel().getValue("leaseholdid"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void finProductChgEvt(boolean fromAfterBindData) {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finProduct)) {
            String finLeaseType = finProduct.getString("financeleasetype");
            boolean isFinLease = FinanceLeaseTypeEnum.isFinanceLease((String)finLeaseType);
            if (isFinLease) {
                this.getModel().setValue("drawway", (Object)"once");
                this.getModel().setValue("issyncdraw", (Object)"1");
            }
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"drawway", "issyncdraw"}, (!isFinLease ? 1 : 0) != 0);
            boolean isLeaseBackNoSale = FinanceLeaseTypeEnum.isLeaseBackNoSale((String)finLeaseType);
            String rePurchase = isLeaseBackNoSale ? "0" : "1";
            this.getView().setEnable(Boolean.valueOf(!isLeaseBackNoSale), new String[]{"repurchase"});
            if (!fromAfterBindData || "ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repurchase", (Object)rePurchase);
            }
        }
        this.isSyncDrawChgEvt();
    }

    private void amountChgEvt() {
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"syncdrawamount", (Object)amount);
        }
    }

    private void isSyncDrawChgEvt() {
        String drawWay = (String)this.getModel().getValue("drawway");
        this.getView().setEnable(Boolean.valueOf(StringUtils.equals((CharSequence)drawWay, (CharSequence)"stage")), new String[]{"syncdrawamount"});
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw) {
            DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
            boolean isShow = true;
            if (null != finProduct) {
                isShow = !FinanceLeaseTypeEnum.isFinanceLease((String)finProduct.getString("financeleasetype"));
            }
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"fs_syncdraw"});
        }
        this.endDateChgEvt();
    }

    private void endDateChgEvt() {
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw) {
            Date endDate = (Date)this.getModel().getValue("enddate");
            this.getModel().setValue("expiredate", (Object)endDate);
        }
    }

    private void endRevDateChgEvt() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_rentplan");
        Date endRevDate = (Date)this.getModel().getValue("endrevdate");
        if (null != endRevDate) {
            this.getModel().setValue("paydate", (Object)endRevDate, rowIndex);
        }
    }

    private void startDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw && null != startDate) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawdate", (Object)startDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"startintdate", (Object)startDate);
        }
    }

    private void orgChgEvt() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            model.beginInit();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"debtor", (Object)org.getPkValue());
            model.endInit();
        }
    }

    private void setDynamicField() {
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
        if (EmptyUtil.isEmpty((BigDecimal)totalAmt)) {
            totalAmt = (BigDecimal)this.getModel().getValue("amount");
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"laontotalamt", (Object)totalAmt);
        DynamicObjectCollection rentPlans = this.getModel().getEntryEntity("entry_rentplan");
        BigDecimal payedRent = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rentPlans)) {
            payedRent = rentPlans.stream().filter(v -> ExecuteStatusEnum.isExecuted((String)v.getString("executestatus"))).map(v -> v.getBigDecimal("rentamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payedrent", (Object)payedRent);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unpayedrent", (Object)totalAmt.subtract(payedRent));
        this.getModel().setDataChanged(false);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"repurchaseamt"});
    }
}

