/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.contractbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fl.business.helper.PayPlanUpdateHelper;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class LeaseContractList
extends AbstractTmcBillBaseList {
    public void setFilter(SetFilterEvent e) {
        List qFilter = e.getQFilters();
        qFilter.add(new QFilter("loantype", "=", (Object)"finlease"));
        if (!this.getBillFormId().endsWith("_init")) {
            QFilter auditFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            auditFilter.and("isinit", "=", (Object)"1");
            auditFilter.or("isinit", "=", (Object)"0");
            qFilter.add(auditFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isquerydefault;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn bizDateFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"startdate")).findFirst().orElse(null);
        if (bizDateFilterCol != null && null != (isquerydefault = (String)formShowParameter.getCustomParam("isquerydefault")) && isquerydefault.equals("no")) {
            bizDateFilterCol.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long selectedId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        List<String> singleProcOps = Arrays.asList("rentpayplan", "pushrepayment", "pushreceipt", "addfee");
        if (singleProcOps.contains(operateKey) && EmptyUtil.isEmpty((Long)super.getSelectedId())) {
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushreceipt") && PayPlanUpdateHelper.isFinLeaseTypeContract((Object)(selectedId = super.getSelectedId()))) {
            this.getView().showTipNotification(FlFormResourceEnum.LeaseContractList_0.loadKDString());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operateResult = args.getOperationResult();
        if (operateResult == null || !operateResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "rentpayplan": {
                Object selectId = operateResult.getSuccessPkIds().get(0);
                this.openRentPlan(selectId);
                break;
            }
            case "feeshare": {
                Long contractId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)contractId)) {
                    return;
                }
                this.getView().invokeOperation("pushfeeshare");
                break;
            }
            case "trackrepay": {
                this.trackRePay(operateResult.getSuccessPkIds());
                break;
            }
            case "trackrealcard": {
                this.trackRealCard(operateResult.getSuccessPkIds());
                break;
            }
        }
    }

    private void trackRePay(List<Object> ids) {
        DynamicObjectCollection rentPayBills = QueryServiceHelper.query((String)"fl_rentpaybill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{new QFilter("loancontractbill", "in", ids)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rentPayBills)) {
            this.getView().showTipNotification(FlFormResourceEnum.LeaseContractList_1.loadKDString());
            return;
        }
        Map dataMap = rentPayBills.stream().collect(Collectors.groupingBy(v -> v.get("loancontractbill"), Collectors.mapping(r -> r.getLong("id"), Collectors.toList())));
        for (Object id : ids) {
            List rentPayIds = dataMap.get(id);
            if (!EmptyUtil.isNoEmpty(rentPayIds)) continue;
            ArrayList<Tuple> billTuple = new ArrayList<Tuple>();
            billTuple.add(Tuple.create((Object)"fl_rentpaybill", rentPayIds));
            TmcBotpHelper.showTrackParameter(billTuple, (IFormView)this.getView());
        }
    }

    private void trackRealCard(List<Object> ids) {
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"id,leaseholdid", (QFilter[])new QFilter[]{new QFilter("ID", "in", ids), new QFilter("leaseholdid", ">", (Object)0)});
        Map<Object, Long> contractMap = contractBills.stream().collect(Collectors.toMap(v -> v.get("ID"), r -> r.getLong("leaseholdid")));
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id,srcbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", ids)});
        Map dataMap = realCards.stream().collect(Collectors.groupingBy(v -> v.get("srcbillid"), Collectors.mapping(r -> r.getLong("ID"), Collectors.toList())));
        for (Object id : ids) {
            List realCardIds = dataMap.getOrDefault(id, new ArrayList());
            if (EmptyUtil.isEmpty((Collection)realCardIds) && null != contractMap.get(id)) {
                realCardIds.add(contractMap.get(id));
            }
            ArrayList<Tuple> billTuple = new ArrayList<Tuple>();
            if (EmptyUtil.isNoEmpty((Object)realCardIds)) {
                billTuple.add(Tuple.create((Object)"fa_card_real", (Object)realCardIds));
            }
            TmcBotpHelper.showTrackParameter(billTuple, (IFormView)this.getView());
        }
    }

    private void openRentPlan(Object selectId) {
        BillShowParameter sp = new BillShowParameter();
        sp.setPkId(selectId);
        sp.setStatus(OperationStatus.EDIT);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        sp.setFormId("fl_payplanbill");
        this.getView().showForm((FormShowParameter)sp);
    }
}

