/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.convert;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;
import org.apache.commons.lang3.tuple.Pair;

public class LeaseContract2RealCardConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntity = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntity);
        Map<Object, Long> contractOrgMap = this.getContractOrgMap(extendedDataEntities);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            Object srcBillId = realCard.get("srcbillid");
            Long orgId = contractOrgMap.get(srcBillId);
            Pair<DynamicObject, DynamicObject> funcOrgPair = this.getFuncOrgPair(orgId);
            if (EmptyUtil.isEmpty(funcOrgPair)) {
                throw new KDBizException(FlFormResourceEnum.LeaseContract2RealCardConvertPlugin_0.loadKDString());
            }
            realCard.set("assetunit", funcOrgPair.getLeft());
            realCard.set("org", funcOrgPair.getRight());
        }
    }

    private Map<Object, Long> getContractOrgMap(ExtendedDataEntity[] extendedDataEntities) {
        Object[] ids = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(v -> v.get("srcbillid")).toArray();
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"id,org", (QFilter[])new QFilter("ID", "in", (Object)ids).toArray());
        return contractBills.stream().collect(Collectors.toMap(v -> v.get("ID"), r -> r.getLong("org")));
    }

    private Pair<DynamicObject, DynamicObject> getFuncOrgPair(Long orgId) {
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"fl", (String)"fl_leasecontractbill", (String)"47156aff000000ac");
        Long assetOrg = 0L;
        Long accountOrg = 0L;
        Long tempOrgId = orgId;
        while (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{assetOrg, accountOrg})) {
            Map orgParentMap;
            if (!authOrgIds.contains(tempOrgId)) continue;
            if (EmptyUtil.isEmpty((Long)assetOrg) && OrgUnitServiceHelper.checkOrgFunction((Long)tempOrgId, (String)"09")) {
                assetOrg = tempOrgId;
            }
            if (EmptyUtil.isEmpty((Long)accountOrg) && OrgUnitServiceHelper.checkOrgFunction((Long)tempOrgId, (String)"10")) {
                accountOrg = tempOrgId;
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{assetOrg, accountOrg}) || CollectionUtils.isEmpty((Map)(orgParentMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"08", Collections.singletonList(tempOrgId)))) || Objects.equals(orgParentMap.get(tempOrgId), 0L) || Objects.equals(orgParentMap.get(tempOrgId), tempOrgId)) break;
            tempOrgId = (Long)orgParentMap.get(tempOrgId);
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{assetOrg, accountOrg})) {
            return null;
        }
        Map orgMap = TmcDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList(assetOrg, accountOrg))});
        return Pair.of(orgMap.get(assetOrg), orgMap.get(accountOrg));
    }
}

